theory question_2_0
imports Main

begin

typedecl entity
typedecl event

consts
  MarineBiomes :: "entity ⇒ bool"
  SaltWater :: "entity ⇒ bool"
  Ocean :: "entity ⇒ bool"
  Animal :: "entity ⇒ bool"
  SeaTiger :: "entity ⇒ bool"
  LivesWithin :: "entity ⇒ entity ⇒ bool"

(* Explanation 1: Marine biomes are found in the salt water of the ocean. *)
axiomatization where
  explanation_1: "∀x. MarineBiomes x ⟶ SaltWater x ∧ Ocean x"

(* Explanation 2: Another animal that lives within the Marine Biome is a sea tiger. *)
axiomatization where
  explanation_2: "∃x m. Animal x ∧ SeaTiger x ∧ LivesWithin x m ∧ MarineBiomes m"

theorem hypothesis:
  assumes asm: "SeaTiger x"
  (* Hypothesis: Sea tigers are found in the salt water of the ocean. *)
  shows "SaltWater x ∧ Ocean x"
proof -
  from asm have " SeaTiger x" by simp
  then obtain m where m: "LivesWithin x m ∧ MarineBiomes m" using explanation_2 by blast
  then have "SaltWater m ∧ Ocean m" using explanation_1 by blast
  have conclusion: "SaltWater x ∧ Ocean x" using m by simp
  show ?thesis using asm conclusion by blast
qed

end
