theory question_99_1
imports Main

begin

typedecl entity
typedecl event

consts
  Dog :: "entity ⇒ bool"
  Grass :: "entity ⇒ bool"
  Running :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  On :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"

(* Explanation 1: A dog could also be running on grass. *)
axiomatization where
  explanation_1: "∀x y. Dog x ∧ Grass y ⟶ (∃e. Running e ∧ Agent e x ∧ On e y ∧ Patient e y)"

theorem hypothesis:
  (* Premise: A dog running on grass *)
  assumes asm: "Dog x ∧ Grass y ∧ Running e ∧ Agent e x ∧ On e y ∧ Patient e y"
  (* Hypothesis: A dog is on the grass. *)
  shows "∃x. Dog x ∧ On e ∧ Grass y ∧ Agent e x"
proof -
  from asm have "Dog x" and "Grass y" and "Agent e x" and "On e y" and "Patient e y" by auto
  then have "Running e" using asm by blast
  then have "∃x. Dog x ∧ On e ∧ Grass y ∧ Agent e x" using asm by blast
  then show ?thesis by blast
qed

end
