theory question_65_4

imports Main

begin

typedecl entity
typedecl event

consts
  One :: "entity ⇒ entity ⇒ bool"
  Person :: "entity ⇒ bool"
  Alone :: "entity ⇒ bool"
  Lying :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Field :: "entity ⇒ bool"
  Large :: "entity ⇒ bool"
  Green :: "entity ⇒ bool"
  Outdoor :: "entity ⇒ bool"

(* Premise: ∃x e. Person(x) ∧ Lying(e) ∧ Agent(e, x) ∧ ∃y. Field(y) ∧ Large(y) ∧ Green(y) ∧ In(x, y) *)
theorem hypothesis:
  assumes asm: "Person x ∧ Lying e ∧ Agent e x ∧ Field y ∧ Large y ∧ Green y ∧ In x y"
  shows "∃x. Person x ∧ Alone x ∧ Field y ∧ Outdoor y ∧ In x y"
proof -
  from asm have "Person x" by auto
  then have "∃x. Person x ∧ Alone x" using explanation_1 by auto
  from asm have "Field y ∧ Large y ∧ Green y" by auto
  from this have "Field y ∧ Outdoor y" using explanation_2 by auto
  from asm have "In x y" by auto
  then show ?thesis using `Person x` `Alone x` `Field y` `Outdoor y` by blast
qed

end
