theory question_57_2
imports Main

begin

typedecl entity
typedecl event

consts
  MaintenanceWorker :: "entity ⇒ bool"
  Worker :: "entity ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  WalkingPast :: "event ⇒ entity ⇒ bool"
  Statue :: "entity ⇒ bool"
  Under :: "event ⇒ entity ⇒ entity ⇒ bool"

(* Explanation 1: A maintenance worker is a worker. *)
axiomatization where
  explanation_1: "∀x. MaintenanceWorker x ⟶ Worker x"

(* Explanation 2: A maintenance worker walking past an statue implies the worker is walking past the statue and under the statue. *)
axiomatization where
  explanation_2: "∀x e y. MaintenanceWorker x ∧ WalkingPast e x ∧ Statue y ∧ Under e x y ⟶ Agent e x ∧ WalkingPast e x ∧ Under e x y"

theorem hypothesis:
  (* Premise: None *)
  assumes asm: "True"
  (* Hypothesis: A worker is walking by a statue. *)
  shows "∃x y e. Worker x ∧ Statue y ∧ WalkingPast e ∧ Agent e x ∧ Under e x y"
proof -
  obtain x where "MaintenanceWorker x" using asm by blast
  then have "Worker x" using explanation_1 by blast
  obtain e y where "Statue y ∧ WalkingPast e x ∧ Under e x y" using asm by blast
  then have "Agent e x ∧ WalkingPast e x ∧ Under e x y" using explanation_2 by blast
  then show ?thesis using `Worker x` `Statue y` `WalkingPast e` `Agent e x` `Under e x y` by blast
qed

end
