theory question_46_0
imports Main

begin

typedecl entity
typedecl event

consts
  Boy :: "entity ⇒ bool"
  Fruit :: "entity ⇒ bool"
  StreetCart :: "entity ⇒ bool"
  StreetVendor :: "entity ⇒ bool"
  Sells :: "entity ⇒ event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  Location :: "entity ⇒ event ⇒ bool"
  Wearing :: "entity ⇒ entity ⇒ bool"
  Orange :: "entity ⇒ bool"

(* Explanation 1: If the boy sells fruit from a street cart, he is a street vendor. *)
axiomatization where
  explanation_1: "∀x y z e. Boy x ∧ Fruit y ∧ StreetCart z ⟶ (StreetVendor x ∧ Sells e x ∧ Agent e x ∧ Patient e y ∧ Location z e)"

theorem hypothesis:
  (* Premise: A boy in an orange shirt sells fruit from a street cart. *)
  assumes asm: "Boy x ∧ Wearing x y ∧ Orange y ∧ Fruit z ∧ Sells z x ∧ StreetCart z"
  (* Hypothesis: A boy is a street vendor. *)
  shows "∃x. Boy x ∧ StreetVendor x"
proof -
  from asm have "Boy x" "Fruit z" "Sells z x" "StreetCart z" by auto
  then have "StreetVendor x" using explanation_1 by blast
  then show "∃x. Boy x ∧ StreetVendor x" using asm by blast
qed

end
