theory question_45_3

imports Main

begin

typedecl entity
typedecl event

consts
  Woman :: "entity ⇒ bool"
  Street :: "entity ⇒ bool"
  Running :: "entity ⇒ entity ⇒ bool"
  Black :: "entity ⇒ bool"
  Clothing :: "entity ⇒ bool"
  Barefoot :: "entity ⇒ bool"
  Person :: "entity ⇒ bool"
  Bicycle :: "entity ⇒ bool"
  Riding :: "entity ⇒ entity ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"

(* Explanation: A woman in black clothing runs down the street. *)
axiomatization where
  explanation: "∀w bf s. Woman w ∧ Black bf ∧ Clothing bf ∧ Barefoot w ∧ Street s ∧ Running w s ⟶ Outdoors w"

theorem hypothesis:
  (* Premise: A woman in black clothing runs down the street barefoot next to two people on bicycles and a female runner. *)
  assumes asm: " Woman w  ∧ Black c  ∧ Clothing c  ∧ Barefoot w  ∧ Street s  ∧ Running w  s  ∧  Person x  ∧ Person y  ∧ Bicycle z  ∧ Riding x  z  ∧ Riding y  z  ∧ Agent r  w   "
  (* Hypothesis: The woman is outdoors. *)
  shows "Outdoors w "
proof -
  from asm have "Running w s" by fast
  then have "Outdoors w" using explanation by blast
  show ?thesis using `Outdoors w` by blast
qed

end
