theory question_36_4
imports Main

begin

typedecl entity
typedecl event

consts
  Busy :: "entity ⇒ bool"
  CityStreet :: "entity ⇒ bool"
  Street :: "entity ⇒ bool"
  Has :: "entity ⇒ entity ⇒ bool"
  Many :: "entity ⇒ bool"
  People :: "entity ⇒ bool"

(* Explanation 1: A busy city street implies the street has many people. *)
axiomatization where
  explanation_1: "∀x y. Busy x ∧ CityStreet y ∧ Street y ⟶ Has y z ∧ Many z ∧ People z"

theorem hypothesis:
  (* Premise: none *)
  assumes asm: "true"
  (* Hypothesis: The street has a lot of people. *)
  shows "∃x. Street x  ∧ Many y  ∧ People y  ∧ Has x  y "
proof -
  from asm have "true" by blast
  then have "∃w. CityStreet w ∧ Busy w" by blast
  then have "∃x. Street x ∧ Has x y ∧ Many y ∧ People y" using explanation_1 by blast
  then show ?thesis by blast
qed

end
