theory question_20_10
imports Main

begin

typedecl entity

consts
  Infant :: "entity ⇒ bool"
  Baby :: "entity ⇒ bool"
  Crying :: "entity ⇒ bool"
  Unhappy :: "entity ⇒ bool"

(* Explanation 1: An infant is a baby. *)
axiomatization where
  explanation_1: "∀x. Infant x ⟶ Baby x"

(* Explanation 2: A crying infant is an unhappy baby, specifically, an unhappy baby is a baby who is crying. *)
axiomatization where
  explanation_2: "∀x. Infant x ∧ Crying x ⟶ Unhappy x"

theorem hypothesis:
  (* Premise: none *)
  assumes asm:
    (* Hypothesis: A baby is unhappy. *)
  shows "∃x. Baby x ∧ Unhappy x"
proof -
  assume asm
  then have inf_baby: "Infant x" for x using explanation_1 by blast
  then have cry_unhappy: "Unhappy x" for x using explanation_2 asm by blast
  then have baby_unhappy: "Baby x ∧ Unhappy x" for x using inf_baby by blast
  then show ?thesis using baby_unhappy by blast
qed

end
