theory question_81_7

imports Main

begin

typedecl entity
typedecl event

consts
  ExternalMigration :: "entity ⇒ bool"
  Entity :: "entity ⇒ bool"
  Cause :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  SuddenReduction :: "event ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  PopulationSize :: "entity ⇒ event ⇒ bool"
  SpecificEntity :: "entity ⇒ bool"
  BottleneckEffect :: "event ⇒ bool"
  Occur :: "event ⇒ bool"
  Result :: "event ⇒ event ⇒ bool"

(* Explanation 1: External migration can cause a sudden reduction in the population size of a specific entity. *)
axiomatization where
  explanation_1: "∀x y e1 e2. ExternalMigration x ∧ Entity y ⟶ (∃e1 e2. Cause e1 ∧ Agent e1 x ∧ SuddenReduction e2 ∧ Patient e2 y ∧ PopulationSize y e2 ∧ SpecificEntity y)"

(* Explanation 2: If a sudden reduction in the population size of a specific entity occurs, then the bottleneck effect occurs in that entity. *)
axiomatization where
  explanation_2: "∀x e1 e2. Entity x ∧ SuddenReduction e1 ∧ PopulationSize x e1 ∧ SpecificEntity x ⟶ (∃e2. BottleneckEffect e2 ∧ Occur e2 ∧ Patient e2 x)"

(* Explanation 3: The bottleneck effect is a result of a sudden reduction in the population size of a specific entity. *)
axiomatization where
  explanation_3: "∀x e1 e2. BottleneckEffect e1 ∧ Result e2 e1 ⟷ (∃x. Entity x ∧ SuddenReduction e2 ∧ PopulationSize x e2 ∧ SpecificEntity x)"

theorem hypothesis:
  assumes asm: "ExternalMigration x"
  (* Hypothesis: Bottleneck effect can occur with external migration. *)
  shows "∃e. BottleneckEffect e ∧ Occur e ∧ Agent e x"
proof -
  from asm have "ExternalMigration x" by simp
  then obtain e1 y where e1: "Cause e1 ∧ Agent e1 x ∧ SuddenReduction e1 ∧ Patient e1 y ∧ PopulationSize y e1 ∧ SpecificEntity y" using explanation_1 by blast
  then have "BottleneckEffect e2 ∧ Occur e2 ∧ Patient e2 y" using explanation_2 by blast
  then obtain e2 where e2: "BottleneckEffect e2 ∧ Occur e2 ∧ Patient e2 y" by blast
  have "Agent e2 x" using e1 e2 by blast
  then show ?thesis using e2 `BottleneckEffect e2` `Occur e2` by blast
qed

end
