theory question_81_0
imports Main

begin

typedecl entity
typedecl event

consts
  Population :: "entity ⇒ bool"
  BottleneckEffect :: "event ⇒ bool"
  Occurs :: "event ⇒ bool"
  Suddenly :: "event ⇒ bool"
  Gets :: "event ⇒ entity ⇒ bool"
  MuchSmaller :: "entity ⇒ event ⇒ bool"
  Growth :: "entity ⇒ event ⇒ bool"
  ExternalMigration :: "event ⇒ bool"
  Reduced :: "event ⇒ bool"
  By :: "event ⇒ event ⇒ bool"
  With :: "event ⇒ entity ⇒ bool"

(* Explanation 1: Bottleneck effect occurs when a population suddenly gets much smaller. *)
axiomatization where
  explanation_1: "∀x e1 e2. Population x ⟶ (∃e1 e2. BottleneckEffect e1 ∧ Occurs e1 ∧ Population x ∧ Suddenly e2 ∧ Gets e2 x ∧ MuchSmaller x e2)"

(* Explanation 2: Population growth is reduced by external migration. *)
axiomatization where
  explanation_2: "∀x y e1 e2. Population x ∧ Growth y e1 ∧ ExternalMigration e1 ⟶ (∃e2. Reduced e2 ∧ Growth y e2 ∧ By e2 e1)"

theorem hypothesis:
  assumes asm: "ExternalMigration e"
  (* Hypothesis: Bottleneck effect can occur with external migration. *)
  shows "∃e. BottleneckEffect e ∧ Occurs e ∧ With e x"
proof -
  from asm have "ExternalMigration e" by simp
  then have "∃x y e1. Population x ∧ Growth y e1 ∧ ExternalMigration e1" by blast
  then obtain x y e1 where e1: "Population x ∧ Growth y e1 ∧ ExternalMigration e1" by blast
  from e1 have "∃e2. Reduced e2 ∧ Growth y e2 ∧ By e2 e1" using explanation_2 by blast
  then obtain e2 where e2: "Reduced e2 ∧ Growth y e2 ∧ By e2 e1" by blast
  have "BottleneckEffect e2 ∧ Occurs e2 ∧ With e2 x" sorry
  then show ?thesis using e2 by blast
qed

end
