theory question_14_5

imports Main

begin

typedecl entity
typedecl event

consts
  FissileIsotopes :: "entity ⇒ bool"
  Isotope :: "entity ⇒ bool"
  Dividing :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  IntoTwoParts :: "event ⇒ bool"

(* Explanation 1: A fissile isotope is a type of isotope that is capable of dividing into two parts. *)
axiomatization where
  explanation_1: "∀x y. FissileIsotopes x ∧ Isotope y ⟶ (∃e. Dividing e ∧ Agent e x ∧ IntoTwoParts e)"

theorem hypothesis:
  assumes asm: "FissileIsotopes x"
  (* Hypothesis: Fissile isotopes are capable of dividing into two parts. *)
  shows "∃e. Dividing e ∧ Agent e x ∧ IntoTwoParts e"
proof -
  from asm have "FissileIsotopes x" by simp
  then obtain e where e: "Dividing e ∧ Agent e x ∧ IntoTwoParts e" using explanation_1 by blast
  show ?thesis using e by simp
qed

end
