theory question_99_2

imports Main

begin
typedecl entity
typedecl event
consts
  Running :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  Grass :: "entity ⇒ bool"
  On :: "entity ⇒ entity ⇒ bool"
  Dog :: "entity ⇒ bool"

(* Explanation 1: Running on grass implies being on the grass. *)
axiomatization where
  explanation_1: "∀x y e. Running e ∧ Agent e x ∧ Patient e y ∧ Grass y ⟶ On x y"

theorem hypothesis:
  (* Premise: A dog is running on grass. *)
  assumes asm: "Dog x ∧ Grass y ∧ Running e ∧ Agent e x ∧ Patient e y"
  (* Hypothesis: A dog is on the grass. *)
  shows "∃x y. Dog x ∧ Grass y ∧ On x y"
proof -
  from asm have "Running e ∧ Agent e x ∧ Patient e y ∧ Grass y" by blast
  then have "On x y" using explanation_1 by blast
  show ?thesis using asm `Dog x` `Grass y` `On x y` by blast
qed

end
