theory question_86_2
imports Main

begin

typedecl entity
typedecl event

consts
  Conversing :: "entity ⇒ bool"
  Talking :: "entity ⇒ bool"
  Women :: "entity ⇒ bool"
  Three :: "entity ⇒ bool"
  Table :: "entity ⇒ bool"
  Drinks :: "entity ⇒ bool"
  At :: "entity ⇒ entity ⇒ bool"
  With :: "entity ⇒ entity ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"

(* Explanation 1: Conversing is a form of Talking. *)
axiomatization where
  explanation_1: "∀x. Conversing x ⟶ Talking x"

(* Explanation 2: If entities are Conversing, then they are Talking. *)
axiomatization where
  explanation_2: "∀x. Conversing x ⟶ Talking x"

theorem hypothesis:
  (* Premise: There are three woman conversing at a table with drinks. *)
  assumes asm: "Women x  ∧ Three x  ∧ Table y  ∧ Drinks z  ∧ Conversing e  ∧ Agent ev x  ∧ At x  y  ∧ With x  z "
  (* Hypothesis: Women are talking *)
  shows "∃x ev. Women x  ∧ Talking x  ∧ Agent ev x "
proof -
  from asm have "Conversing e" by blast
  from this have "Talking x" using explanation_1 explanation_2 by blast
  from asm have "Agent ev x" by blast
  show ?thesis using `Women x` `Talking x` `Agent ev x` by blast
qed

end
