theory question_60_0
imports Main
begin

typedecl entity
typedecl event

consts
  Boy :: "entity ⇒ bool"
  KarateForm :: "entity ⇒ bool"
  Uniform :: "entity ⇒ bool"
  Poses :: "entity ⇒ entity ⇒ bool"
  Shows :: "entity ⇒ entity ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"

(* Explanation 1: A boy poses in karate form and uniform means the boy shows "his uniform. *)"
axiomatization
where
  explanation_1: "∀x y. Boy x ∧ KarateForm y ∧ Uniform y ∧ Poses x y ⟶ Shows x y"

theorem hypothesis:
  (* Premise: A boy poses in karate form and uniform. *)
  assumes asm: "Boy x ∧ KarateForm y ∧ Uniform y ∧ Poses x y"
  (* Hypothesis: A boy shows "his uniform. *)"
  shows "∃x y e. Boy x ∧ Uniform y ∧ Shows e ∧ Agent e x ∧ Patient e y"
proof -
  from asm have "Boy x ∧ KarateForm y ∧ Uniform y ∧ Poses x y" by blast
  then have "Shows x y" using explanation_1 by blast
  then show ?thesis using asm `x` `y` by blast
qed

end
