theory question_51_5

imports Main

begin
typedecl entity
typedecl event
consts
  Man :: "entity ⇒ bool"
  Speech :: "entity ⇒ bool"
  OrnateCostumeParty :: "entity ⇒ bool"
  Gives :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  At :: "event ⇒ entity ⇒ bool"

(* Explanation: A man giving a speech is an act of public speaking. *)
axiomatization where
  explanation: "∀x y e. Man x ∧ Speech y ∧ Gives e ∧ Agent e x ∧ Patient e y ⟶ PublicSpeaking e"

theorem premise:
  (* Premise: A man gives a speech at an ornate costume party. *)
  assumes asm: "Man x ∧ Speech y ∧ OrnateCostumeParty z ∧ Gives e ∧ Agent e x ∧ Patient e y ∧ At e z"
  shows "∃x y e. Man x ∧ Speech y ∧ Gives e ∧ Agent e x ∧ Patient e y"
proof -
  from asm have "Man x ∧ Speech y ∧ Gives e ∧ Agent e x ∧ Patient e y" by blast
  then have "PublicSpeaking e" using explanation by blast
  then show ?thesis using asm `Man x` `Speech y` `Gives e` `Agent e x` `Patient e y` by blast
qed

end
