theory question_30_8

imports Main

begin
typedecl entity
typedecl event
consts
  Man :: "entity ⇒ bool"
  Human :: "entity ⇒ bool"
  Skateboard :: "entity ⇒ bool"
  TricksOn :: "entity ⇒ entity ⇒ bool"
  DoingTricks :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"

(* Explanation: If a man is tricking on someone, then there is an event of doing tricks where the man is the agent and the person is the patient. *)
axiomatization where
  explanation: "∀x y e. Man x ∧ TricksOn x y ⟹ DoingTricks e ∧ Agent e x ∧ Patient e y"

theorem hypothesis:
  (* Premise: A man is doing tricks on a skateboard. *)
  assumes asm: "Man x ∧ Skateboard y ∧ DoingTricks e ∧ Agent e x ∧ Patient e y"
  (* Hypothesis: A human is doing tricks. *)
  shows "∃x e. Human x ∧ DoingTricks e ∧ Agent e x"
proof -
  from asm have "Man x" by blast
  from this have "Human x" using explanation by blast
  from asm have "DoingTricks e ∧ Agent e x" by blast
  show ?thesis using `Human x` `DoingTricks e` `Agent e x` by blast
qed

end
