theory question_30_4

imports Main

begin

typedecl entity
typedecl event
consts
  Human :: "entity ⇒ bool"
  Skateboard :: "entity ⇒ bool"
  DoingTricks :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  On :: "event ⇒ entity ⇒ bool"
  Inference :: "event ⇒ bool"

(* Explanation 1: Logical form: ∃x y e. Human(x) ∧ Skateboard(y) ∧ DoingTricks(e) ∧ Agent(e, x) ∧ On(e, y) *)
axiomatization where
  explanation_1: "∃x y e. Human x ∧ Skateboard y ∧ DoingTricks e ∧ Agent e x ∧ On e y"

(* Explanation 2: Logical form: ∃x e. Human(x) ∧ DoingTricks(e) ∧ Agent(e, x) ∧ Inference(e) *)
axiomatization where
  explanation_2: "∃x e. Human x ∧ DoingTricks e ∧ Agent e x ∧ Inference e"

theorem hypothesis:
  (* Premise: Logical form: ∃x y e. Man(x) ∧ Skateboard(y) ∧ DoingTricks(e) ∧ Agent(e, x) ∧ On(e, y) *)
  assumes asm: "Man x ∧ Skateboard y ∧ DoingTricks e ∧ Agent e x ∧ On e y"
  (* Hypothesis: Logical form: ∃x e. Human(x) ∧ DoingTricks(e) ∧ Agent(e, x) ∧ Inference(e) *)
  shows "∃x e. Human x ∧ DoingTricks e ∧ Agent e x ∧ Inference e"
proof -
  from asm have "Man x" by blast
  from this have "Human x" using explanation_1 by blast
  from asm have "Skateboard y" by blast
  from this have "DoingTricks e" using explanation_1 by blast
  from asm have "Agent e x" by blast
  from this have "Inference e" using explanation_2 by blast
  show ?thesis using `Human x` `DoingTricks e` `Agent e x` `Inference e` by blast
qed

end
