theory question_99_0

imports Main

begin

typedecl entity

consts
  VegetableOil :: "entity ⇒ bool"
  RenewableResource :: "entity ⇒ bool"
  Fuel :: "entity ⇒ bool"
  OrganicallyProducedVegetableOil :: "entity ⇒ bool"
  MostRenewableFuel :: "entity ⇒ bool"
  DieselEngine :: "entity ⇒ bool"
  Burn :: "entity ⇒ bool"
  Agent :: "entity ⇒ entity ⇒ bool"
  Patient :: "entity ⇒ entity ⇒ bool"

(* Explanation 1: Vegetable oil is a renewable resource. *)
axiomatization where
  explanation_1: "∀x. VegetableOil x ⟶ RenewableResource x"

(* Explanation 2: Vegetable oil is a kind of fuel. *)
axiomatization where
  explanation_2: "∀x. VegetableOil x ⟶ Fuel x"  

theorem hypothesis:
  (* Premise: Diesel engines can burn many kinds of fuel. *)
  assumes asm: "DieselEngine x ∧ Fuel y ∧ Burn e ∧ Agent e x ∧ Patient e y"
  (* Hypothesis: Organically produced vegetable oil is the most renewable fuel for a diesel engine. *)
  shows "∃x. OrganicallyProducedVegetableOil x ∧ MostRenewableFuel x"
proof -
  have "∃x. VegetableOil x ∧ Fuel x" using explanation_2 by auto
  then have "∃x. VegetableOil x ∧ RenewableResource x" using explanation_1 by auto
  then show ?thesis by blast
qed

end
