theory question_11_0

imports Main

begin

typedecl entity
typedecl event

consts
  ElectricalConductor :: "entity ⇒ bool"
  Outlet :: "entity ⇒ bool"
  Circuit :: "entity ⇒ bool"
  Plugged :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  Completed :: "event ⇒ bool"
  CompleteElectricalCircuit :: "entity ⇒ bool"
  SourceOfElectricalEnergy :: "entity ⇒ bool"
  Electricity :: "entity ⇒ bool"
  ElectricalEnergy :: "entity ⇒ bool"
  Safe :: "entity ⇒ bool"
  Harm :: "entity ⇒ bool"
  Danger :: "entity ⇒ bool"
  Appliances :: "entity ⇒ bool"
  Plugging :: "event ⇒ bool"
  Dangerous :: "event ⇒ bool"
  InDanger :: "entity ⇒ bool"
  AroundDangerous :: "entity ⇒ bool"
  Electrocution :: "entity ⇒ bool"
  Organism :: "entity ⇒ bool"
  Causes :: "event ⇒ bool"
  BodyOfAnimal :: "entity ⇒ bool"
  Flows :: "event ⇒ bool"
  Transferred :: "event ⇒ bool"
  Electrocuted :: "event ⇒ bool"
  Animal :: "entity ⇒ bool"
  SafeAround :: "event ⇒ entity ⇒ bool"

(* Explanation 1: when an electrical conductor is plugged into an outlet , a circuit is completed. *)
axiomatization where
  explanation_1: "∀x y z e1 e2. ElectricalConductor x ∧ Outlet y ∧ Circuit z ∧ Plugged e1 ∧ Agent e1 x ∧ Patient e1 y ⟶ Completed e2 ∧ Agent e2 z"

(* Explanation 2: a complete electrical circuit is a source of electrical energy. *)
axiomatization where
  explanation_2: "∀x y. CompleteElectricalCircuit x ⟶ SourceOfElectricalEnergy y"

(* Explanation 3: electricity means electrical energy. *)
axiomatization where
  explanation_3: "∀x y. Electricity x ⟷ ElectricalEnergy y"

(* Explanation 4: safe is the opposite of harm; danger. *)
axiomatization where
  explanation_4: "∀x y z. Safe x ⟷ ¬Harm y ∧ ¬Danger z"

(* Explanation 5: plugging many appliances into one outlet is dangerous. *)
axiomatization where
  explanation_5: "∀x y e. Appliances x ∧ Outlet y ∧ Plugging e ∧ Agent e x ∧ Patient e y ⟶ Dangerous e"

(* Explanation 6: to be in danger means to be around; to be near something dangerous. *)
axiomatization where
  explanation_6: "∀x y. InDanger x ⟷ AroundDangerous y"

(* Explanation 7: electrocution causes harm to an organism. *)
axiomatization where
  explanation_7: "∀x y e. Electrocution x ∧ Organism y ∧ Causes e ∧ Agent e x ∧ Patient e y"

(* Explanation 8: if electricity flows through; is transferred through the body of an animal then that animal is electrocuted. *)
axiomatization where
  explanation_8: "(∃e1 e2 x y. Electricity x ∧ BodyOfAnimal y ∧ Flows e1 ∧ Agent e1 x ∧ Patient e1 y ∧ Transferred e2 ∧ Agent e2 x ∧ Patient e2 y) ⟶ (∃e3 z. Animal z ∧ Electrocuted e3 ∧ Agent e3 z)"

(* Explanation 9: an animal is a kind of organism. *)
axiomatization where
  explanation_9: "∀x. Animal x ⟶ Organism x"

theorem hypothesis:
  assumes asm: "Appliances x ∧ Outlet y ∧ Electricity z ∧ Plugging e ∧ Agent e x ∧ Patient e y"
  (* Hypothesis: Plugging many appliances into one outlet is not a way to stay safe around electricity. *)
  shows "¬SafeAround e z"
proof -
  from asm have "Appliances x ∧ Outlet y ∧ Electricity z ∧ Plugging e ∧ Agent e x ∧ Patient e y" by simp
  then have "Dangerous e" using explanation_5 by blast
  then have "¬Safe e" using explanation_4 by blast
  show ?thesis using asm `¬Safe e` by blast
qed

end
