theory question_31_0

imports Main

begin

typedecl entity
typedecl event

consts
  Object :: "entity ⇒ bool"
  Sharpening :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Change :: "event ⇒ bool"
  Shape :: "entity ⇒ bool"
  ElectricSharpener :: "entity ⇒ bool"
  Metal :: "entity ⇒ bool"
  Removes :: "event ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  Causes :: "event ⇒ bool"
  Waves :: "entity ⇒ bool"
  Material :: "entity ⇒ bool"
  Changed :: "event ⇒ bool"
  Removing :: "event ⇒ bool"

(* Explanation 1: sharpening an object causes that object to change shape *)
axiomatization where
  explanation_1: "∀x e1 e2. Object x ∧ Sharpening e1 ∧ Agent e1 x ⟶ (Change e2 ∧ Agent e2 x ∧ Shape x)"

(* Explanation 2: An electric sharpener removes too much metal and often causes waves *)
axiomatization where
  explanation_2: "∀x y e1 e2. ElectricSharpener x ∧ Metal y ∧ Removes e1 ∧ Agent e1 x ∧ Patient e1 y ⟶ Causes e2 ∧ Agent e2 x ∧ Waves x"  

theorem hypothesis:
  assumes asm: "Object x ∧ Material y ∧ Changed e1 ∧ Agent e1 x ∧ Removing e2 ∧ Agent e2 x ∧ Patient e2 y"
  (* Hypothesis: One way an object's shape can be changed is by removing material. *)
  shows "Shape x"
proof -
  from asm have "Object x" by simp
  then obtain e2 where e2: "Change e2 ∧ Agent e2 x ∧ Shape x" using explanation_1 by blast
  then have "Shape x" using explanation_2 by blast
  have conclusion: "Shape x" using e2 by simp
  show ?thesis using asm conclusion `Shape x` by blast
qed

end
