theory question_81_0

imports Main

begin
typedecl entity
typedecl event

consts
  Bike :: "entity ⇒ bool"
  Bicycle :: "entity ⇒ bool"
  Person :: "entity ⇒ bool"
  Soaring :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Outside :: "entity ⇒ bool"
  Helmet :: "entity ⇒ bool"
  Skyline :: "entity ⇒ bool"
  Lake :: "entity ⇒ bool"
  Wears :: "event ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  Jumps :: "event ⇒ bool"
  InFrontOf :: "entity ⇒ entity ⇒ entity ⇒ bool"

(* Explanation 1: Bike is the short word for bicycle, and the person is outside if the person is soaring over the ground. *)
axiomatization where
  explanation_1: "∀x y e. Bike x ∧ Bicycle x ∧ Person y ∧ Soaring e ∧ Agent e y ⟶ Outside y"

theorem hypothesis:
  (* Premise: A person on a bicycle wears a helmet and jumps, soaring over the ground in front of a skyline and lake. *)
  assumes asm: "Person x ∧ Bicycle y ∧ Helmet z ∧ Skyline s ∧ Lake l ∧ Wears e1 ∧ Agent e1 x ∧ Patient e1 z ∧ Jumps e2 ∧ Agent e2 x ∧ Soaring e3 ∧ Agent e3 x ∧ InFrontOf x s l"
  (* Hypothesis: A person outside with a bike. *)
  shows "∃x y. Person x ∧ Bike y ∧ Outside x"
proof -
  from asm have "Person x ∧ Bicycle y ∧ Soaring e3 ∧ Agent e3 x" by blast
  then have "Person x ∧ Bike y ∧ Outside x" using explanation_1 by blast
  then show ?thesis using asm by blast
qed

end
