theory question_36_8

imports Main

begin
typedecl entity
typedecl event

consts
  BusyCityStreet :: "entity ⇒ bool"
  Street :: "entity ⇒ bool"
  People :: "entity ⇒ bool"
  Has :: "entity ⇒ entity ⇒ bool"
  Winter :: "entity ⇒ bool"
  Walking :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  In :: "event ⇒ entity ⇒ bool"

(* Explanation 1: A busy city street is a street. *)
axiomatization where
  explanation_1: "∀x. BusyCityStreet x ⟶ Street x"

(* Explanation 2: A busy city street has a lot of people. *)
axiomatization where  
  explanation_2: "∃x y. BusyCityStreet x ∧ People y ∧ Has x y"

theorem hypothesis:
  (* Premise: People walking down a busy city street in the winter. *)
  assumes asm: "People x ∧ BusyCityStreet y ∧ Winter z ∧ Walking e ∧ Agent e x ∧ Patient e y ∧ In e z"
  (* Hypothesis: The street has a lot of people. *)
  shows "∃x y. Street x ∧ People y ∧ Has x y"
proof -
  from asm have "People x ∧ BusyCityStreet y" by blast
  from this have "Street y ∧ People x ∧ Has y x" using explanation_2 by blast
  then show ?thesis using asm by blast
qed

end
