theory question_30_0

imports Main

begin
typedecl entity
typedecl event

consts
  Tricks :: "entity ⇒ bool"
  Skateboard :: "entity ⇒ bool"
  On :: "entity ⇒ entity ⇒ bool"
  Inferred :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  Man :: "entity ⇒ bool"
  Human :: "entity ⇒ bool"
  Doing :: "event ⇒ bool"

(* Explanation 1: tricks on a skateboard is inferred as doing tricks *)
axiomatization where
  explanation_1: "∀x y e. Tricks x ∧ Skateboard y ∧ On x y ⟶ Inferred e ∧ Agent e x ∧ Patient e y"

theorem hypothesis:
  (* Premise: A man is doing tricks on a skateboard. *)
  assumes asm: "Man x ∧ Tricks y ∧ Skateboard z ∧ Doing e ∧ Agent e x ∧ Patient e y ∧ On y z"
  (* Hypothesis: A human doing tricks *)
  shows "∃x y e. Human x ∧ Tricks y ∧ Doing e ∧ Agent e x ∧ Patient e y"
proof -
  from asm have "Man x ∧ Tricks y ∧ Doing e ∧ Agent e x ∧ Patient e y" by blast
  then have "Human x ∧ Tricks y ∧ Doing e ∧ Agent e x ∧ Patient e y" using explanation_1 by blast
  then show ?thesis using asm by blast
qed

end
