theory question_97_0
imports Main

begin

typedecl entity
typedecl event

consts
  Galaxies :: "entity ⇒ bool"
  Shape :: "entity ⇒ bool"
  Classify :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"

(* Explanation 1: galaxies can be classified by shape. *)
axiomatization where
  explanation_1: "∀x y e. Galaxies x ∧ Shape y ∧ Classify e ∧ Agent e y ∧ Patient e x"

(* Explanation 2: shape is a kind of physical property. *)
axiomatization where
  explanation_2: "∀x. Shape x ⟶ PhysicalProperty x"

(* Explanation 3: a property of something is a feature of that something. *)
axiomatization where
  explanation_3: "∀x y. Property x ∧ Something y ⟶ Feature x y"

theorem hypothesis:
  (* Premise: Just as biologists classify living things, astronomers classify galaxies. *)
  assumes asm: "Biologists x ∧ LivingThings y ∧ Classify e1 ∧ Agent e1 x ∧ Patient e1 y ∧ Astronomers z ∧ Galaxies w ∧ Classify e2 ∧ Agent e2 z ∧ Patient e2 w"
  (* Hypothesis: Shape is used to classify galaxies. *)
  shows "∃x y e. Shape x ∧ Galaxies y ∧ Classify e ∧ Agent e x ∧ Patient e y"
proof -
  from asm have "Galaxies y" by simp
  then obtain e where e: "Shape x ∧ Classify e ∧ Agent e y ∧ Patient e x" using explanation_1 by blast
  then have "Shape x" using explanation_2 by blast
  have conclusion: "Shape x ∧ Classify e ∧ Agent e y ∧ Patient e x" using e by simp
  show ?thesis using conclusion `Galaxies y` by blast
qed

end
