theory question_87_3
imports Main
begin

typedecl entity
typedecl event

consts
  Limestone :: "entity ⇒ bool"
  RockType :: "entity ⇒ bool"
  UsefulForStudying :: "event ⇒ bool"
  HistoryOfLivingOrganisms :: "entity ⇒ bool"
  Is :: "entity ⇒ entity ⇒ bool"

(* Explanation 1: Limestone is a type of sedimentary rock. *)
axiomatization where
  explanation_1: "∀x y. Limestone x ∧ SedimentaryRock y ⟶ Is x y"

(* Explanation 2: Limestone is useful in studying the history of living organisms. *)
axiomatization where
  explanation_2: "∀x y z e. Limestone x ∧ UsefulForStudying e ∧ HistoryOfLivingOrganisms z ⟶ Is e x ∧ Is e y ∧ Is e z"

(* Explanation 3: Limestone implies being a type of sedimentary rock. *)
axiomatization where
  explanation_3: "∀x y. Limestone x ⟶ (Implies y ∧ Being y ∧ SedimentaryRock x)"

theorem hypothesis:
  assumes asm: "Limestone x"
  (* Hypothesis: Limestone is the rock type that is useful in studying the history of living organisms. *)
  shows "∃x y z e. Limestone x ∧ RockType y ∧ UsefulForStudying e ∧ HistoryOfLivingOrganisms z ∧ Is e x ∧ Is e y ∧ Is e z"
proof -
  from asm have "Limestone x" by simp
  then have "∃y. SedimentaryRock y ∧ Is x y" using explanation_1 by blast
  then obtain y where y: "SedimentaryRock y ∧ Is x y" by blast
  then have "UsefulForStudying e ∧ HistoryOfLivingOrganisms z ∧ Is e x ∧ Is e y ∧ Is e z" using explanation_2 asm y by blast
  then show ?thesis using asm `∃y. SedimentaryRock y ∧ Is x y` by blast
qed

end
