theory question_77_1
imports Main
begin

typedecl entity
typedecl event

consts
  Mass :: "entity ⇒ bool"
  PropertyOf :: "entity ⇒ entity ⇒ bool"
  Matter :: "entity ⇒ bool"
  Volume :: "entity ⇒ bool"
  DifferentTypes :: "entity ⇒ bool"
  ComposedOf :: "entity ⇒ entity ⇒ bool"
  Aluminum :: "entity ⇒ bool"
  Copper :: "entity ⇒ bool"
  Has :: "event ⇒ bool"

(* Explanation 1: Mass is a property of matter. *)
axiomatization where
  explanation_1: "∀x. Mass x ⟶ PropertyOf x Matter"

(* Explanation 2: Volume is a property of matter. *)
axiomatization where
  explanation_2: "∀x. Volume x ⟶ PropertyOf x Matter"

theorem hypothesis:
  (* Premise: aluminum and copper are composed of different types of matter. *)
  assumes asm: "Aluminum x ∧ Copper y ∧ DifferentTypes z ∧ ComposedOf x z ∧ ComposedOf y z"
  (* Hypothesis: Matter has mass and volume. *)
  shows "∃x e. Matter x ∧ Has e ∧ Mass x ∧ Volume x"
proof -
  from asm have "ComposedOf x z" by simp
  from asm have "ComposedOf y z" by simp
  from explanation_1 have "Mass z" using asm by blast
  from explanation_2 have "Volume z" using asm by blast
  then show ?thesis using `Mass z` `Volume z` by blast
qed

end
