theory question_64_0
imports Main
begin

typedecl entity
typedecl event

consts
  FoodSupply :: "entity ⇒ bool"
  Environment :: "entity ⇒ bool"
  Decreases :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  Decrease :: "event ⇒ bool"
  PopulationOfAnimals :: "event ⇒ bool"
  InEnvironment :: "event ⇒ entity ⇒ bool"
  Field :: "entity ⇒ bool"
  Animal :: "entity ⇒ bool"
  Mouse :: "entity ⇒ bool"

(* Explanation 1: as the supply of food in an environment decreases, the population of animals in that environment will decrease. *)
axiomatization where
  explanation_1: "∀x y e1 e2. FoodSupply x ∧ Environment y ∧ Decreases e1 ∧ Agent e1 x ∧ Patient e1 y ⟶ (∃e2. Decrease e2 ∧ PopulationOfAnimals e2 ∧ InEnvironment e2 y)"

(* Explanation 2: a field is a kind of environment. *)
axiomatization where
  explanation_2: "∀x. Field x ⟶ Environment x"

(* Explanation 3: a mouse is a kind of animal. *)
axiomatization where
  explanation_3: "∀x. Mouse x ⟶ Animal x"

theorem hypothesis:
  (* Premise: if its food supply in a field decreases *)
  assumes asm: "FoodSupply x ∧ Field y ∧ Decreases e ∧ InEnvironment e y"
  (* Hypothesis: The mouse population in that field will probably decrease. *)
  shows "∃e. Decrease e ∧ PopulationOfAnimals e ∧ InEnvironment e y"
proof -
  from asm have "Field y" using explanation_2 by blast
  then have "Environment y" using explanation_2 by blast
  then have "FoodSupply x ∧ Environment y ∧ Decreases e ∧ Agent e x ∧ Patient e y" using asm by blast
  then obtain e1 where e1: "Decrease e1 ∧ PopulationOfAnimals e1 ∧ InEnvironment e1 y" using explanation_1 by blast
  then show ?thesis using e1 by blast
qed

end
