theory question_61_2

imports Main

begin

typedecl entity
typedecl event

consts
  Sun :: "entity ⇒ bool"
  LargestBody :: "entity ⇒ bool"
  CelestialBody :: "entity ⇒ bool"
  SolarSystem :: "entity ⇒ bool"
  Star :: "entity ⇒ bool"

(* Explanation 1: The Sun is the largest celestial body in our solar system. *)
axiomatization where
  explanation_1: "∀x. Sun x ⟶ (LargestBody x ∧ CelestialBody x ∧ SolarSystem x)"

(* Explanation 2: The Sun is a kind of star and the largest body in our solar system. *)
axiomatization where
  explanation_2: "∀x. Sun x ⟶ (Star x ∧ LargestBody x ∧ SolarSystem x)"

(* Explanation 3: The Sun is the largest body in our solar system. *)
axiomatization where
  explanation_3: "∀x. Sun x ⟶ (LargestBody x ∧ SolarSystem x)"

theorem hypothesis:
  assumes asm: "Sun x"
  (* Hypothesis: The largest body in our solar system is the Sun. *)
  shows "∃x. Sun x ∧ LargestBody x ∧ SolarSystem x"
proof -
  from asm have "Sun x" by simp
  then have "LargestBody x ∧ SolarSystem x" using explanation_3 by blast
  then have "Star x" using explanation_2 by blast
  show ?thesis using asm `LargestBody x ∧ SolarSystem x` by blast
qed

end
