theory question_36_0
imports Main
begin

typedecl entity
typedecl event

consts
  Tall :: "entity ⇒ bool"
  GreatInHeight :: "entity ⇒ bool"
  Means :: "entity ⇒ entity ⇒ bool"
  
(* Explanation 1: tall means great in height. *)
axiomatization where
  explanation_1: "∀e. Tall e ⟶ (∃x. GreatInHeight x ∧ Means e x)"

consts
  Measuring :: "entity ⇒ bool"
  ScienceSkill :: "entity ⇒ bool"
  
(* Explanation 2: measuring is a kind of science skill. *)
axiomatization where
  explanation_2: "∀x. Measuring x ⟶ ScienceSkill x"

consts
  Temperature :: "entity ⇒ bool"
  MeasureOf :: "entity ⇒ entity ⇒ bool"
  HeatEnergy :: "entity"
  
(* Explanation 3: temperature is a measure of heat energy. *)
axiomatization where
  explanation_3: "∀x. Temperature x ⟶ MeasureOf x HeatEnergy"

consts
  Height :: "entity ⇒ bool"
  LengthFromTopToBottom :: "entity"
  
(* Explanation 4: height is a measure of length from the top of an object to the bottom of an object. *)
axiomatization where
  explanation_4: "∀x. Height x ⟶ MeasureOf x LengthFromTopToBottom"


theorem hypothesis:
  (* Premise: students want to find out at measuring temperature bean plants grow tallest. *)
  assumes asm: "Students x ∧ Measuring e ∧ Temperature y ∧ BeanPlants z ∧ Grow e z ∧ Find e y"
  (* Hypothesis: The science process skill of measuring would be used to find this temperature. *)
  shows "∃e. Measuring e ∧  Temperature y ∧ Find e y "
proof -
  from asm have "Measuring e" using explanation_2 by blast
  then have "Temperature y" using explanation_3 by blast
  then have "Find e y" using asm by blast
  show ?thesis using `Measuring e` `Temperature y` `Find e y` by blast
qed

end
