theory question_13_0
imports Main
begin

typedecl entity
typedecl event

consts
  Boiling :: "event ⇒ bool"
  Evaporation :: "event ⇒ bool"
  Change :: "event ⇒ bool"
  From :: "event ⇒ entity ⇒ bool"
  Into :: "event ⇒ entity ⇒ bool"
  Add :: "event ⇒ entity ⇒ bool"
  HeatEnergy :: "entity ⇒ bool"
  Heating :: "event ⇒ bool"
  Means :: "event ⇒ event ⇒ bool"
  Heat :: "event ⇒ bool"
  Water :: "entity ⇒ bool"
  Liquid :: "entity ⇒ bool"
  Disappears :: "event ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  Evaporated :: "event ⇒ bool"
  Probably :: "event ⇒ bool"
  Gone :: "event ⇒ bool"
  StateOfMatter :: "entity ⇒ bool"
  Gas :: "entity ⇒ bool"
  Pan :: "entity ⇒ bool"
  All :: "entity ⇒ entity ⇒ bool"
  StateChanging :: "event ⇒ bool"
  Example :: "event ⇒ event ⇒ bool"

(* Explanation 1: boiling;evaporation means change from a liquid into a gas by adding heat energy. *)
axiomatization where
  explanation_1: "∀e1 e2. Boiling e1 ∧ Evaporation e2 ⟶ (Change e1 ∧ From e1 Liquid ∧ Into e1 Gas ∧ Add e1 HeatEnergy)"

(* Explanation 2: heating means adding heat. *)
axiomatization where
  explanation_2: "∀e1 e2. Heating e1 ∧ Means e1 e2 ⟶ Add e2 Heat"

(* Explanation 3: heat means heat energy. *)
axiomatization where
  explanation_3: "∀e1 e2. Heat e1 ∧ Means e1 e2 ⟶ HeatEnergy e2"

(* Explanation 4: water is a kind of liquid. *)
axiomatization where
  explanation_4: "∀x. Water x ⟶ Liquid x"

(* Explanation 5: if a liquid disappears then that liquid probably evaporated. *)
axiomatization where
  explanation_5: "∀x e1 e2. Liquid x ⟶ (Disappears e1 ∧ Patient e1 x) ⟶ (Evaporated e2 ∧ Probably e2)"

(* Explanation 6: disappeared is similar to gone. *)
axiomatization where
  explanation_6: "∀e1 e2. Disappeared e1 ⟶ Gone e2"

(* Explanation 7: liquid is a kind of state of matter. *)
axiomatization where
  explanation_7: "∀x. Liquid x ⟶ StateOfMatter x"

(* Explanation 8: gas is a kind of state of matter. *)
axiomatization where
  explanation_8: "∀x. Gas x ⟶ StateOfMatter x"

theorem hypothesis:
  assumes asm: "Pan x ∧ Water y"
  (* Hypothesis: Heating a pan of water until the water is all gone is an example of matter changing state. *)
  shows "∃x y z e1 e2. Pan x ∧ Water y ∧ Heating e1 ∧ Agent e1 x ∧ Patient e1 y ∧ Gone z ∧ All z y ∧ StateChanging e2 ∧ Example e2 e1"
proof -
  from asm have "Pan x" and "Water y" by simp+
  then have "Liquid y" using explanation_4 by blast
  then obtain e1 where e1: "Heating e1 ∧ Agent e1 x ∧ Patient e1 y" using explanation_2 by blast
  then have "Add e1 Heat" using explanation_2 by blast
  then have "HeatEnergy e1" using explanation_3 by blast
  then obtain e2 where e2: "Boiling e2 ∧ Evaporation e2 ∧ Change e2 ∧ From e2 Liquid ∧ Into e2 Gas ∧ Add e2 HeatEnergy" using explanation_1 by blast
  then have "Disappears e1 ∧ Patient e1 y" using e1 by simp
  then obtain z where z: "Gone z" using explanation_6 by blast
  then have "All z y" using z by simp
  then have "StateChanging e2" using z by simp
  then have "Example e2 e1" using e2 by simp
  show ?thesis using `Pan x` `Water y` e1 z e2 by blast
qed

end
