theory question_85_0

imports Main

begin

typedecl entity
typedecl event

consts
  PressureReceptors :: "entity ⇒ bool"
  Skin :: "entity ⇒ bool"
  Found :: "event ⇒ bool"
  Location :: "event ⇒ entity ⇒ entity ⇒ bool"
  Mainly :: "event ⇒ bool"
  PacinianCorpuscles :: "entity ⇒ bool"

(* Explanation 1: Pressure receptors are found mainly in the skin. *)
axiomatization where
  explanation_1: "∀x y. PressureReceptors x ∧ Skin y ⟶ (∃e. Found e ∧ Location e x y ∧ Mainly e)"

(* Explanation 2: Pacinian corpuscles are pressure receptors. *)
axiomatization where
  explanation_2: "∀x. PacinianCorpuscles x ⟶ PressureReceptors x"

theorem hypothesis:
  assumes asm: "PacinianCorpuscles x ∧ Skin y"
  (* Hypothesis: Pacinian corpuscles are found mainly in the skin. *)
  shows "∃e. Found e ∧ Location e x y ∧ Mainly e"
proof -
  from asm have "PacinianCorpuscles x" and "Skin y" by auto
  then obtain e where e: "Found e ∧ Location e x y ∧ Mainly e" using explanation_1[where x="x" and y="y"] by blast
  then show ?thesis using e by blast
qed

end
