theory question_81_5

imports Main

begin

typedecl entity
typedecl event

consts
  ExternalMigration :: "entity ⇒ bool"
  BottleneckEffect :: "entity ⇒ bool"
  Trigger :: "event ⇒ entity ⇒ bool"
  Triggered :: "event ⇒ entity ⇒ bool"
  Occurs :: "event ⇒ bool"
  Lead :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Occurrence :: "event ⇒ bool"
  Result :: "event ⇒ event ⇒ bool"

(* Explanation 1: External migration can trigger the bottleneck effect. *)
axiomatization where
  explanation_1: "∀e x. ExternalMigration x ∧ BottleneckEffect x ⟶ Trigger e x"

(* Explanation 2: When the bottleneck effect is triggered, it occurs as a result. *)
axiomatization where
  explanation_2: "∀e1 e2 x. BottleneckEffect x ∧ Triggered e1 x ⟶ Occurs e2"

(* Explanation 3: Therefore, external migration can lead to the occurrence of the bottleneck effect. *)
axiomatization where
  explanation_3: "∀e1 e2 x. ExternalMigration x ⟶ (∃e. Lead e1 ∧ Agent e1 x ∧ Occurrence e2 ∧ Result e2 e)"

theorem hypothesis:
  assumes asm: "BottleneckEffect x ∧ ExternalMigration x"
  (* Hypothesis: Bottleneck effect can occur with external migration. *)
  shows "∃e x. BottleneckEffect x ∧ ExternalMigration x ∧ Occur e ∧ Trigger e x"
proof -
  from asm have "BottleneckEffect x ∧ ExternalMigration x" by simp
  then have "Trigger e x" using explanation_1 by blast
  then obtain e2 where e2: "Occurs e2" using explanation_2[where e1=e and x=x] by blast
  obtain e1 where e1: "Lead e1 ∧ Agent e1 x ∧ Occurrence e2 ∧ Result e2 e" using explanation_3[where e2=e2 and x=x] by blast
  have conclusion: "Lead e1 ∧ Agent e1 x ∧ Occurrence e2 ∧ Result e2 e" using e1 by simp
  show ?thesis using asm conclusion `Trigger e x` by blast
qed

end
