theory question_63_4

imports Main

begin

typedecl entity
typedecl event

consts
  SedimentaryRocks :: "entity ⇒ bool"
  FormedByDeposition :: "entity ⇒ bool"
  Sandstone :: "entity ⇒ bool"
  SedimentaryRock :: "entity ⇒ bool"
  Include :: "entity ⇒ entity ⇒ entity ⇒ bool"
  Rocks :: "entity ⇒ bool"

(* Explanation 1: Sedimentary rocks are formed by deposition. *)
axiomatization where
  explanation_1: "∀x y. SedimentaryRocks x ∧ FormedByDeposition y"

(* Explanation 2: Sandstone is a type of sedimentary rock, and rocks formed by deposition can specifically include sandstone as one of their types. *)
axiomatization where
  explanation_2: "∀x y z. Sandstone x ∧ SedimentaryRock y ∧ FormedByDeposition z ⟶ Include z x y"

(* Explanation 3: Rocks formed by deposition are specifically sandstone. *)
axiomatization where
  explanation_3: "∀x y. Rocks x ∧ FormedByDeposition y ⟶ Sandstone x"

theorem hypothesis:
  assumes asm: "Rocks x ∧ FormedByDeposition y"
  (* Hypothesis: Rocks formed by deposition are sandstone. *)
  shows "Sandstone x"
proof -
  from asm have "Rocks x ∧ FormedByDeposition y" by simp
  then have "Sandstone x" using explanation_3 by blast
  then show ?thesis using asm by blast
qed

end
