theory question_4_1
imports Main

begin

typedecl entity
typedecl event

consts
  Amphibians :: "entity ⇒ bool"
  TrueTetrapods :: "entity ⇒ bool"
  Vertebrates :: "entity ⇒ bool"
  FourLimbs :: "entity ⇒ bool"
  Ancathostega :: "entity ⇒ bool"
  EarliestTetrapodsFound :: "entity ⇒ bool"
  MostComplete :: "entity ⇒ bool"
  Possesses :: "entity ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"

(* Explanation 1: Amphibians are the first true tetrapods, or vertebrates with four limbs. *)
axiomatization where
  explanation_1: "∀x. Amphibians x ⟶ (TrueTetrapods x ∧ Vertebrates x ∧ FourLimbs x)"

(* Explanation 2: Ancathostega is one of the earliest tetrapods found, and by far the most complete. *)
axiomatization where
  explanation_2: "∀x. Ancathostega x ⟶ (EarliestTetrapodsFound x ∧ MostComplete x)"

(* Explanation 3: Ancathostega, as one of the earliest tetrapods found, possesses four limbs. *)
axiomatization where
  explanation_3: "∀x e. Ancathostega x ∧ EarliestTetrapodsFound x ∧ FourLimbs e ∧ Possesses e ∧ Agent e x"

theorem hypothesis:
  assumes asm: "Ancathostega x"
  (* Hypothesis: Ancathostega have four limbs. *)
  shows "∃x e. Ancathostega x ∧ FourLimbs e ∧ Possesses e ∧ Agent e x"
proof -
  from asm have "Ancathostega x" by simp
  then obtain e where e: "EarliestTetrapodsFound x ∧ MostComplete x" using explanation_2 by blast
  then have "FourLimbs e ∧ Possesses e ∧ Agent e x" using explanation_3 by blast
  have conclusion: "EarliestTetrapodsFound x ∧ MostComplete x" using e by simp
  show ?thesis using asm conclusion `FourLimbs e ∧ Possesses e ∧ Agent e x` by blast
qed

end
