theory question_98_2

imports Main

begin
typedecl entity
typedecl event

consts
  YoungMan :: "entity ⇒ bool"
  Goggles :: "entity ⇒ bool"
  Wearing :: "entity ⇒ entity ⇒ bool"
  Jumping :: "event ⇒ bool"
  OutOfPool :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Splashing :: "event ⇒ bool"
  Everywhere :: "event ⇒ bool"
  Man :: "entity ⇒ bool"

(* Explanation 1: The young man wearing goggles is the same man jumping out of the pool. *)
axiomatization where
  explanation_1: "∃x y e. YoungMan x ∧ Goggles y ∧ Wearing x y ∧ Jumping e ∧ OutOfPool e ∧ Agent e x"
  

theorem hypothesis:
  (* Premise: A young man wearing goggles, is jumping out of a pool, splashing water everywhere. *)
  assumes asm: "YoungMan x ∧ Goggles y ∧ Wearing x y ∧ Jumping e1 ∧ OutOfPool e1 ∧ Agent e1 x ∧ Splashing e2 ∧ Everywhere e2 ∧ Agent e2 x"
  (* Hypothesis: Man jumping out of a pool. *)
  shows "∃x e. Man x ∧ Jumping e ∧ OutOfPool e ∧ Agent e x"
proof -
  from asm have "YoungMan x ∧ Goggles y ∧ Wearing x y ∧ Jumping e1 ∧ OutOfPool e1 ∧ Agent e1 x" by blast
  then have "Man x ∧ Jumping e1 ∧ OutOfPool e1 ∧ Agent e1 x" using explanation_1 by blast
  then show ?thesis using asm by blast
qed

end
