theory question_6_0
imports Main

begin
typedecl entity
typedecl event

consts
  Tumbles :: "entity ⇒ bool"
  Spectators :: "entity ⇒ bool"
  Tumble :: "entity ⇒ bool"
  Man :: "entity ⇒ bool"
  UniversityOfMichigan :: "entity ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Experiencer :: "event ⇒ entity ⇒ bool"
  Location :: "event ⇒ entity ⇒ bool"

(* Explanation 1: A man tumbles as spectators watch is the same as spectators watch a man tumble. *)
axiomatization where
  explanation_1: "∀x y. Tumbles x ∧ Spectators y ⟷ Spectators y ∧ Tumble x"

theorem hypothesis:
  (* Premise: A man tumbles as spectators watch at the University of Michigan. *)
  assumes asm: "Man x ∧ Spectators y ∧ UniversityOfMichigan z ∧ Tumbles e ∧ Agent e x ∧ Experiencer e y ∧ Location e z"
  (* Hypothesis: Spectators watch a man tumble. *)
  shows "∃x y e. Spectators x ∧ Man y ∧ Tumble e ∧ Agent e x ∧ Experiencer e y"
proof -
  from asm have "Tumbles e ∧ Spectators y" by blast
  then have "Spectators y ∧ Tumble e" using explanation_1 by blast
  then show ?thesis using asm by blast
qed

end
