theory question_56_8

imports Main

begin
typedecl entity
typedecl event

consts
  Men :: "entity ⇒ bool"
  BeachShore :: "entity ⇒ bool"
  WearingShorts :: "entity ⇒ bool"
  On :: "entity ⇒ entity ⇒ bool"
  Beach :: "entity"
  Tanned :: "entity ⇒ bool"
  FishingNet :: "entity ⇒ bool"
  Pulling :: "event ⇒ bool"
  Along :: "entity ⇒ entity ⇒ bool"

(* Explanation 1: Men on a beach shore are typically on the beach. *)
axiomatization where
  explanation_1: "∀x. Men x ∧ BeachShore x ⟶ On x Beach"

(* Explanation 2: Men wearing shorts on a beach shore are typically on the beach. *)
axiomatization where
  explanation_2: "∀x. Men x ∧ WearingShorts x ∧ BeachShore x ⟶ On x Beach"

theorem hypothesis:
  (* Premise: Two tanned men wearing shorts are pulling a fishing net along a beach shore. *)
  assumes asm: "Men x ∧ Tanned x ∧ WearingShorts x ∧ FishingNet y ∧ BeachShore z ∧ Pulling e ∧ Agent e x ∧ Patient e y ∧ Along x z"
  (* Hypothesis: The men are on the beach. *)
  shows "∃x. Men x ∧ BeachShore x ∧ On x Beach"
proof -
  from asm have "Men x ∧ BeachShore z" by blast
  then have "On x Beach" using explanation_1 by blast
  then show ?thesis using `Men x` `BeachShore z` by blast
qed

end
