
from langchain.prompts import PromptTemplate
from .math_fewshot import standard_fewshots, cot_fewshots,cot_wrong_fewshots,cot_wrong_fewshots2,reflexion_reflect_fewshot,tips
from .math_fewshot import cot_allwrong_fewshots1, cot_allwrong_fewshots2, cot_allwrong_fewshots3, cot_allwrong_fewshots4,cot_allwrong_fewshots5,cot_allwrong_gold_fewshots,cot_allwrong_generated_gold_fewshots,cot_first3allwrong_fewshots,cot_first3allwrong_fewshots2,cot_fewshots_reason_latter,cot_fewshots_reason_latter2
from .math_fewshot import *
level0 = "Both sides must reach a full consensus on every point of the debate. Every statement must be agreed upon by both sides."
level1 = "Most of the debate should be characterized by disagreements, but there may still be a small amount of consensus on less significant points."
level2 = "It’s not necessary to fully agree with each other’s perspectives, as our objective is to find the correct answer."
level3 = "Both sides must disagree with each other on every point of the debate. There should be no consensus whatsoever."

levels = {0: level0, 1: level1, 2: level2, 3: level3}

###### MAD #############################

_MAD_START = """Can you solve the following math problem? {question} Explain your reasoning. """ + \
"""Your final answer should be a single numerical number, in the form \\boxed{{answer}}, at the end of your response. """
_mad_summarize = """Question: {question}

Answer: {answer}

Summarize the answer to the math problem. Please include the final answer in the form \\boxed{{answer}}, at the end of your summary.
"""
MAD_START = PromptTemplate(
                        input_variables=["question"],
                        template = _MAD_START,
                        )
MAD_SUMMARIZE = PromptTemplate(
                        input_variables=["question","answer"],
                        template = _mad_summarize,
                        )
MATH_MAD_TEMPLATES = {"MAD_START": MAD_START, "MAD_SUMMARIZE": MAD_SUMMARIZE}
##############################################



##### Standard #############################

_standard = """{question} """ + \
"""Your answer should be a single numerical number, in the form \\boxed{{answer}}. """
_standard_enforced = """{question} """ + \
"""Do not output intermediate thoughts. Do not provide any resoning step. Your answer should be a single numerical number, in the form \\boxed{{answer}}. """
_standard_fewshot = """Solve a math problem. Here are some examples:\n""" + \
f"{standard_fewshots}\n" + """(End of Examples)\n""" + \
"""Question: {question} Your answer should be a single numerical number, in the form \\boxed{{answer}}. """
_standard_fewshot2 = """Solve a math problem. Your answer should be a single numerical number, in the form \\boxed{{answer}}. Here are some examples:\n""" + \
f"{standard_fewshots}\n" + """(End of Examples)\n""" + \
"""Question: {question}\nAnswer:"""

# fewshot examples contain intermediate steps
_cot_fewshot = """Solve a math problem. Your answer should be a single numerical number, in the form \\boxed{{answer}}. Here are some examples:\n""" + \
f"{cot_fewshots}\n" + """(End of Examples)\n""" + \
"""Question: {question}\nAnswer:"""
# without borders for fewshot exampels
_cot_just_fewshot = """Solve a math problem. Your answer should be a single numerical number, in the form \\boxed{{answer}}.\n\n""" + \
f"{cot_fewshots}\n\n" + \
"""Question: {question}\nAnswer:"""
_cot_just_fewshot_llama = """Solve a math problem. Your answer should be a single numerical number, in the form \\boxed{{answer}}.\n\n""" + \
f"{cot_fewshots_llama}\n\n" + \
"""Question: {question}\nAnswer:"""
# fewshot examples doesn't have intermediate steps. But the prompt emphasizes
_cot_fewshot2 = """Solve a math problem. Explain your reasonings step by step. Your answer should be a single numerical number, in the form \\boxed{{answer}}. Here are some examples:\n""" + \
f"{standard_fewshots}\n" + """(End of Examples)\n""" + \
"""Question: {question}\nAnswer:"""
# fewshot examples contain plausible but wrong intermediate steps
def _cot_fewshot3_change(temp_fewshot_prompt):
    _cot_fewshot3 = """Solve a math problem. Explain your reasonings step by step. Your answer should be a single numerical number, in the form \\boxed{{answer}}. Here are some examples:\n""" + \
    f"{temp_fewshot_prompt}\n" + """(End of Examples)\n""" + \
    """Question: {question}\nAnswer:"""
    COT_FEWSHOT_PROMPT3_ = PromptTemplate(
                        input_variables=["question"],
                        template = _cot_fewshot3)
    return COT_FEWSHOT_PROMPT3_

def _llama_cot_fewshot(fewshot):
    # print(fewshot)
    temp = """Solve a math problem. Your answer should be a single numerical number, in the form \\boxed{{answer}}.\n\n""" + \
f"{fewshot}\n\n" + \
"""Question: {question}\nAnswer:"""
    # temp = """Question: {question}\nAnswer:"""

    PROMPT = PromptTemplate(
                        input_variables=["question"],
                        template = temp)
    return PROMPT
def _llama_cot_fewshot_ansformat1(fewshot):
    temp = """Solve a math problem. Your answer should be a single numerical number, in the form [answer].\n\n""" + \
f"{fewshot}\n\n" + \
"""Question: {question}\n"""
    PROMPT = PromptTemplate(
                        input_variables=["question"],
                        template = temp)
    return PROMPT
def _llama_cot_just_fewshot(fewshot):
    temp =  f"{fewshot}\n\n" + \
"""Question: {question}\n"""
    PROMPT = PromptTemplate(
                        input_variables=["question"],
                        template = temp)
    return PROMPT

STANDARD_PROMPT = PromptTemplate(
                        input_variables=["question"],
                        template = _standard)
STANDARD_PROMPT_ENFORCED = PromptTemplate(
                        input_variables=["question"],
                        template = _standard_enforced)
STANDARD_FEWSHOT_PROMPT = PromptTemplate(
                        input_variables=["question"],
                        template = _standard_fewshot2)
COT_FEWSHOT_PROMPT = PromptTemplate(
                        input_variables=["question"],
                        template = _cot_fewshot)
COT_JUST_FEWSHOT_PROMPT = PromptTemplate(
                        input_variables=["question"],
                        template = _cot_just_fewshot)
COT_FEWSHOT_PROMPT2 = PromptTemplate(
                        input_variables=["question"],
                        template = _cot_fewshot2)

reason_wrongs = {"cot_fewshot3_1":_cot_fewshot3_change(cot_wrong_fewshots),
          'cot_fewshot3_2': _cot_fewshot3_change(cot_wrong_fewshots2)}

all_wrongs = {
            "cot_allwrong_fewshots1":_cot_fewshot3_change(cot_allwrong_fewshots1),
          'cot_allwrong_fewshots2': _cot_fewshot3_change(cot_allwrong_fewshots2),
          'cot_allwrong_fewshots3': _cot_fewshot3_change(cot_allwrong_fewshots3),
          'cot_allwrong_fewshots4': _cot_fewshot3_change(cot_allwrong_fewshots4),
          'cot_allwrong_fewshots5': _cot_fewshot3_change(cot_allwrong_fewshots5),
          'cot_allwrong_gold_fewshots': _cot_fewshot3_change(cot_allwrong_gold_fewshots),
          'cot_allwrong_generated_gold_fewshots': _cot_fewshot3_change(cot_allwrong_generated_gold_fewshots),
          'cot_allwrong_first3gold_fewshots': _cot_fewshot3_change(cot_fewshots),
          'cot_allwrong_first3_fewshots': _cot_fewshot3_change(cot_first3allwrong_fewshots),
          'cot_allwrong_first3_fewshots2': _cot_fewshot3_change(cot_first3allwrong_fewshots2)}


llama_prompts = {
        "cot_llama_fewshot": _llama_cot_fewshot(standard_fewshots_llama),
        "cot_llama_fewshot2": _llama_cot_fewshot(cot_fewshots_llama),
        "cot_llama_fewshot3": _llama_cot_fewshot(cot_fewshots_llama_reason),
        "cot_llama_fewshot_ansformat1": _llama_cot_fewshot_ansformat1(standard_fewshots_llama),
        "cot_llama_fewshot_ansformat2": _llama_cot_fewshot_ansformat1(cot_fewshots_llama),
        "cot_llama_fewshot_ansformat3": _llama_cot_fewshot_ansformat1(cot_fewshots_llama_reason),
        "cot_llama_just_fewshot": _llama_cot_fewshot_ansformat1(standard_fewshots_llama),
        "cot_llama_just_fewshot2": _llama_cot_fewshot_ansformat1(cot_fewshots_llama),
        "cot_llama_just_fewshot3": _llama_cot_fewshot_ansformat1(cot_fewshots_llama_reason),
        "cot_llama_fewshot2_math": _llama_cot_fewshot(cot_fewshots_llama_MATH),  
}
# print(llama_prompts["cot_llama_fewshot2_math"].format(question="What is 1+1?"))
##############################################



##### MAD with Judge #############################

### 1 ### 
# we need a prompt to get the initial solution:
# 1. we could use the MAD prompt, or
# 2. we could use a prompt that doesn't requrie formatting
MAD_JUDGE_START = PromptTemplate(
                        input_variables=["question"],
                        template = _MAD_START,
                        )
_MAD_JUDGE_START2 = """Can you solve the following math problem? {question} Explain your reasoning. """ + \
"""Give the answer at the end of your response. """
MAD_JUDGE_START2 = PromptTemplate(
                        input_variables=["question"],
                        template = _MAD_JUDGE_START2,
                        )
_MAD_JUDGE_START3 = """Can you solve the following math problem? {question} """ + \
"""Just give an answer without reasoning. """
MAD_JUDGE_START3 = PromptTemplate(
                        input_variables=["question"],
                        template = _MAD_JUDGE_START3,
                        )


### 2 ###
# System Prompts
_player_system_prompt = """You are a debater. Hello and welcome to the math problem solving debate. """ + \
f"{levels[2]}\n" + \
"""The debate topic is to solve the following math problem:\n{question}"""
MAD_JUDGE_PLAYER_SYSTEM = PromptTemplate(
                        input_variables=["question"],
                        template = _player_system_prompt,)
# print(MAD_JUDGE_PLAYER_SYSTEM.format(question="What is 1+1?"))

_jusge_system_prompt = """You are a moderator. There will be two debaters involved in a math problem solving debate. """+\
"""They will present their answers and discuss their perspectives on the following math problem: {question}\n"""+\
"""At the end of each round, you will evaluate answers based on the following criteria:
1. Accuracy: Whether the final answer correctly solve the math problem.
2. Reasoning: Whether the reasoning is logical and sound."""
MAD_JUDGE_JUDGE_SYSTEM = PromptTemplate(
                        input_variables=["question"],
                        template = _jusge_system_prompt,)

### 3 ### 
# Prompt to get the first debate round
_first_payer1_user_prompt = """You think the correct answer is: {solution} Restate your answer and provide your reasons."""
MAD_JUDGE_FIRST_PLAYER1_USER = PromptTemplate(
                        input_variables=["solution"],
                        template = _first_payer1_user_prompt,)

_first_payer2_user_prompt = """{solution}\n\nYou disagree with my answer. Provide your answer and reasons."""
_first_payer2_user_prompt2 = """{solution}\n\nThere is clearly a reasoning error in my answer. Provide your answer and reasons."""

MAD_JUDGE_FIRST_PLAYER2_USER = PromptTemplate(
                        input_variables=["solution"],
                        template = _first_payer2_user_prompt,)


### 4 ###
# prompts for the debate rounds
#1 judge prompts
#2 player prompts
_judge_user_prompt = """Now the {round} round of debate for both sides has ended.

Affirmative side arguing:
{affirmative_ans}

Negative side arguing: 
{negative_ans}

You, as the moderator, will evaluate both sides' answers and determine if there is a clear preference for an answer candidate. """+\
"""If so, please summarize your reasons for supporting affirmative/negative side and give the final answer that you think is correct, """+\
"""and the debate will conclude. If not, the debate will continue to the next round. """+\
"""Now please output your answer in json format, with the format as follows: """+\
"""{{\"Whether there is a preference\": \"Yes or No\", \"Supported Side\": \"Affirmative or Negative\", \"Reason\": \"\", \"Debate Answer\": \"\"}}. """+\
"""The Debate Answer should be a single numerical number. Please strictly output in JSON format, do not output irrelevant content."""

_judge_user_prompt_nojson = """Now the {round} round of debate for both sides has ended.

Affirmative side arguing:
{affirmative_ans}

Negative side arguing: 
{negative_ans}

You, as the moderator, will evaluate both sides' answers and determine if there is a clear preference for an answer candidate. """+\
"""If so, please summarize your reasons for supporting affirmative/negative side and give the final answer that you think is correct, """+\
"""and the debate will conclude. If not, the debate will continue to the next round. """+\
"""Your final answer should be a single numerical number, in the form \\boxed{{answer}}, at the end of your response."""
MAD_JUDGE_JUDGE_USER = PromptTemplate(
                        input_variables=["round","affirmative_ans", "negative_ans"],
                        template = _judge_user_prompt,)
MAD_JUDGE_JUDGE_USER_NOJSON = PromptTemplate(
                        input_variables=["round","affirmative_ans", "negative_ans"],
                        template = _judge_user_prompt_nojson,)

_payer_user_prompt = """{solution}

Do you agree with my reasoning and answer? Please provide your reasons and answer."""
MAD_JUDGE_PLAYER_USER = PromptTemplate(
                        input_variables=["solution"],
                        template = _payer_user_prompt,)

### 5 ### 
# additional technique
_additional1_judge_user_prompt = """Affirmative side arguing: {affirmative_ans}

Negative side arguing: {negative_ans}

Now, what answer candidates do we have? Present them without reasons."""
MAD_JUDGE_JUDGE_USER_ADDITIONAL1 = PromptTemplate(
                        input_variables=["affirmative_ans", "negative_ans"],
                        template = _additional1_judge_user_prompt,)


_additional2_judge_user_prompt = """Therefore, what is the correct answer to the math problem: {question}
Please summarize your reasons and give the final answer that you think is correct. """+\
"""Now please output your answer in json only, with the format as follows: """+\
"""{{\"Reason\": \"\", \"Debate Answer\": \"\"}}. """+\
"""The Debate Answer should be a single numerical number. Please strictly output in JSON format, do not output irrelevant content."""
_additional2_judge_user_nojson_prompt = """Therefore, what is the correct answer to the math problem: {question}
Please summarize your reasons and give the final answer that you think is correct. """+\
"""Your final answer should be a single numerical number, in the form \\boxed{{answer}}, at the end of your response."""

MAD_JUDGE_JUDGE_USER_ADDITIONAL2 = PromptTemplate(
                        input_variables=["question"],
                        template = _additional2_judge_user_prompt,)
MAD_JUDGE_JUDGE_USER_NOJSON_ADDITIONAL2 = PromptTemplate(
                        input_variables=["question"],
                        template = _additional2_judge_user_nojson_prompt,)

##############################################


##### Feedback #############################

_cot_prompt = """Can you solve the following math problem? {question} Explain your reasoning. """ + \
"""Your final answer should be a single numerical number, in the form \\boxed{{answer}}, at the end of your response. """
_cot_prompt_not_just_numerical = """Can you solve the following math problem? {question} Explain your reasoning. """ + \
"""You final answer should be in the form \\boxed{{answer}} at the end of your response. """
_cot_prompt2 = """Can you solve the following math problem? {question} Think step by step and explain your reasoning. """ + \
"""Your final answer should be a single numerical number, in the form \\boxed{{answer}}, at the end of your response. """
_cot_tips_prompt = """Can you solve the following math problem? {question} Explain your reasoning. """ + \
"""Your final answer should be a single numerical number, in the form \\boxed{{answer}}, at the end of your response. """ + \
f"Here are some tips to help you solve the problem:\n{tips}\n(END OF TIPS)"
_cot_list_prompt = """Can you solve the following math problem? {question} Think step by step and explain your reasoning. List each reasoning step with a number. """ + \
"""Your final answer should be a single numerical number, in the form \\boxed{{answer}}, at the end of your response. """
_cot_json_prompt = """Can you solve the following math problem? {question} Explain your reasoning. """ + \
"""please output your answer in json only, with the format as follows:
{{\"Reason\": \"\", \"Answer\": \"\"}}
The Answer should be a single numerical number. Please strictly output in JSON format, do not output irrelevant content."""

COT = PromptTemplate(
                        input_variables=["question"],
                        template = _cot_prompt,
                        )
COT_NOT_JUST_NUMERICAL = PromptTemplate(
                        input_variables=["question"],
                        template = _cot_prompt_not_just_numerical,
                        )
COT_TIPS = PromptTemplate(
                        input_variables=["question"],
                        template = _cot_tips_prompt)
COT_JSON = PromptTemplate(
                        input_variables=["question"],
                        template = _cot_json_prompt,)
COT_LISTED = PromptTemplate(
                        input_variables=["question"],
                        template = _cot_list_prompt)


_feedback_prompt = """Question: {question}\n\n""" + \
"""Incorrect answer: {answer}\n\n""" + \
"""The above answer is INCORRECT. Understand the mistake and figure out the correct answer. Make it as different as possible from this INCORRECT answer."""
JID_FEEDBACK = PromptTemplate(
                        input_variables=["question","answer"],
                        template = _feedback_prompt,
                        )

# value feedback
_cot_value_prompt = """Given a math question, I come up with an answer with my resaoning steps. Can you evaluate whether my answer is correct?
Question: {question}

My answer: {answer}

Please output your evaluation in json only, with the format as follows:
{{\"Reason\": \"\", \"Evaluation\": \"Yes or No\"}}. Please strictly output in JSON format, do not output irrelevant content.""" 
_cot_value_prompt2 = """Given a math question, I come up with an answer with my resaoning steps. Can you evaluate whether my answer is correct? Pay attention to my reasoning steps. I may have made arithmetic mistakes, misunderstood the question, or made incorrect logical steps.
Question: {question}

My answer: {answer}

Please output your evaluation in json only, with the format as follows:
{{\"Reason\": \"\", \"Evaluation\": \"Yes or No\"}}. Please strictly output in JSON format, do not output irrelevant content.""" 
COT_VALUE = PromptTemplate(
                        input_variables=["question","answer"],
                        template = _cot_value_prompt,
                        )


# reflexion
REFLECTION_HEADER = 'You have attempted to answer following question before and failed. The following reflection(s) give a plan to avoid failing to answer the question in the same way you did previously. Use them to improve your strategy of correctly answering the given question.\n'
REFLECTION_AFTER_LAST_TRIAL_HEADER = 'The following reflection(s) give a plan to avoid failing to answer the question in the same way you did previously. Use them to improve your strategy of correctly answering the given question.\n'
LAST_TRIAL_HEADER = 'You have attempted to answer the following question before and failed. Below is the last trial you attempted to answer the question.\n'

_cot_reflection_zeroshot_prompt ="""Can you solve the following math problem? {question} Explain your reasoning. """ + \
"""Your final answer should be a single numerical number, in the form \\boxed{{answer}}, at the end of your response. """
_cot_reflection_reflect_prompt = """You are an advanced reasoning agent that can improve based on self refection. You will be given a previous reasoning trial in which you were given a question to answer. You were unsuccessful in answering the question either because you guessed the wrong answer or there is a phrasing discrepancy with your provided answer and the answer key. In a few sentences, Diagnose a possible reason for failure or phrasing discrepancy and devise a new, concise, high level plan that aims to mitigate the same failure. Use complete sentences. """ + \
f"Here are some examples:\n{reflexion_reflect_fewshot}\n(END OF EXAMPLES)\n" + \
"""Previous trial:\nQuestion: {question}\nAnwer: {prev_ans}\n\n""" + \
"""Reflection:"""
_cot_reflection_reflect_zeroshot_prompt = """You are an advanced reasoning agent that can improve based on self refection. You will be given a previous reasoning trial in which you were given a question to answer. You were unsuccessful in answering the question either because you guessed the wrong answer or there is a phrasing discrepancy with your provided answer and the answer key. In a few sentences, Diagnose a possible reason for failure or phrasing discrepancy and devise a new, concise, high level plan that aims to mitigate the same failure. Use complete sentences.\n""" + \
"""Previous trial:\nQuestion: {question}\nAnswer: {prev_ans}\n\n""" + \
"""Reflection:"""
_cot_reflection_combo_zeroshot_prompt = """Solve the following math problem. Explain your reasonings. """ + \
"""Your final answer should be a single numerical number, in the form \\boxed{{answer}}, at the end of your response.\n""" + \
"""{reflections}\n""" + \
"""Question: {question}{scratchpad}
Answer:"""

REFLEXION_COT_PROPOSE = PromptTemplate(
                        input_variables=["question"],
                        template = _cot_reflection_zeroshot_prompt)
REFLEXION_COT_REFLECT = PromptTemplate(
                        input_variables=["question", "prev_ans"],
                        template = _cot_reflection_reflect_zeroshot_prompt)
REFLEXION_COT_COMBO_PROPOSE = PromptTemplate(
                        input_variables=["reflections", "question", "scratchpad"],
                        template = _cot_reflection_combo_zeroshot_prompt)
REFLEXION_COT_FEWSHOT_REFLECT = PromptTemplate(
                        input_variables=["question", "prev_ans"],
                        template = _cot_reflection_reflect_prompt)

REFLEXION_PROMPT_TEMPLATES = {"REFLEXION": [REFLEXION_COT_PROPOSE, REFLEXION_COT_REFLECT,REFLEXION_COT_COMBO_PROPOSE],
                    "REFLEXION_FEWSHOT": [REFLEXION_COT_PROPOSE, REFLEXION_COT_FEWSHOT_REFLECT,REFLEXION_COT_COMBO_PROPOSE],
}
# _cotreact_reflection_prompt = """Can you solve the following math problem? {question} Explain your reasoning by having a Thought, then finsih with your answer. """ + \
# """Your final answer should be a single numerical number, in the form \\boxed{{answer}}, at the end of your response. """

# _cotreact_reflection_reflect_prompt = """You are an advanced reasoning agent that can improve based on self refection. You will be given a previous reasoning trial in which you were given a question to answer. You were unsuccessful in answering the question either because you guessed the wrong answer with Finish[<answer>] or there is a phrasing discrepancy with your provided answer and the answer key. In a few sentences, Diagnose a possible reason for failure or phrasing discrepancy and devise a new, concise, high level plan that aims to mitigate the same failure. Use complete sentences.""" + \
# """Here are some examples:\n{examples}\n(END OF EXAMPLES)\n""" + \
# """Previous trial:\nQuestion: {question}{prev_ans}\n\n""" + \
# """Reflection:"""

# _cotreact_reflection_combo_prompt = """Solve the following math problem. Explain your reasonings.\n""" + \
# """{reflections}\n""" + \
# """Question: {question}{scratchpad}"""


##############################################





##### Effect of CoT Analysis #############################



_cot_effect1_prompt = """Can you solve the following math problem? {question} """ + \
"""Do not output any intermediate steps. Your answer should be a single numerical number and nothing more, in the form \\boxed{{answer}}."""
_cot_fewshots_effect1_prompt = """Can you solve the following math problem? """ + \
"""Do not output any intermediate steps. Your answer should be a single numerical number, in the form \\boxed{{answer}}. """ + \
f"Here are some examples:\n{standard_fewshots}\n(End of Examples)\n\n" + \
"""Question: {question}\nAnswer: """
_cot_fewshots_effect1_prompt2 = """Can you solve the following math problem? """ + \
f"Here are some examples:\n{standard_fewshots}\n(End of Examples)\n\n" + \
"""Question: {question}\n""" + \
"""Do not output any intermediate steps. Your answer should be a single numerical number, in the form \\boxed{{answer}}. Do not output anything else.\n""" + \
"""Answer: """
_cot_fewshots_effect1_just_fewshot_prompt = f"{standard_fewshots}\n\n" + \
"""Question: {question}\nAnswer: """

_cot_effect2_prompt = """Can you solve the following math problem? {question} """ + \
"""Your final answer should be a single numerical number, in the form \\boxed{{answer}}, at the begining of your response. Give your numerical answer first, then explain your reasoning. """
_cot_fewshots_effect2_prompt = """Can you solve the following math problem? """ + \
"""Your final answer should be a single numerical number, in the form \\boxed{{answer}}, at the begining of your response. Give your numerical answer first, then explain your reasoning. """ + \
f"Here are some examples:\n{cot_fewshots_reason_latter}\n(End of Examples)\n\n" + \
"""Question: {question}\nAnswer: """
_cot_fewshots_effect2_prompt2 = """Can you solve the following math problem? """ + \
"""Your final answer should be a single numerical number, in the form \\boxed{{answer}}, at the begining of your response. Give your numerical answer first, then explain your reasoning. """ + \
f"Here are some examples:\n{cot_fewshots_reason_latter2}\n(End of Examples)\n\n" + \
"""Question: {question}\nAnswer: """
_cot_fewshots_effect2_just_fewshot_prompt = f"{cot_fewshots_reason_latter}\n\n" + \
"""Question: {question}\nAnswer: """

# print(_cot_fewshots_effect1_just_fewshot_prompt)
def make_template(prompt):
    return PromptTemplate(
                        input_variables=["question"],
                        template = prompt)
COT_EFFECT1 = make_template(_cot_effect1_prompt)
COT_EFFECT2 = make_template(_cot_effect2_prompt)
COT_EFFECT3 = COT
CoT_Analysis = {"COT_EFFECT1":COT_EFFECT1,
                "COT_FEWSHOT_EFFECT1":make_template(_cot_fewshots_effect1_prompt),
                "COT_FEWSHOT_EFFECT1_2":make_template(_cot_fewshots_effect1_prompt2),
                "COT_FEWSHOT_EFFECT1_JUSTFEWSHOT":make_template(_cot_fewshots_effect1_just_fewshot_prompt),
                "COT_EFFECT2":COT_EFFECT2,
                "COT_FEWSHOT_EFFECT2":make_template(_cot_fewshots_effect2_prompt),
                "COT_FEWSHOT_EFFECT22":make_template(_cot_fewshots_effect2_prompt2),
                "COT_FEWSHOT_EFFECT2_JUSTFEWSHOT":make_template(_cot_fewshots_effect2_just_fewshot_prompt),
                "COT_EFFECT3":COT_EFFECT3}

_cot_eval_effect1_prompt = """Question: {question}\n\n""" + \
"""Answer: {answer}\n\n""" + \
"""Does the answer correctly answer the question? Just answer with Yes or No and nothing more."""
_cot_eval_effect2_prompt = """Question: {question}\n\n""" + \
"""Answer: {answer}\n\n""" + \
"""Does the answer correctly answer the question?"""
_cot_eval_effect2_prompt2 = """Question: {question}\n\n""" + \
"""Answer: {answer}\n\n""" + \
"""Does the answer correctly answer the question? Think critically."""
_cot_eval_effect3_prompt = """Question: {question}\n\n""" + \
"""Answer: {answer}\n\n""" + \
"""Does the answer correctly answer the question? First output your reasoning and only then output your conclusion. Do not output your conclusion first. State your conclusion as Yes or No at the end of your response."""
_cot_eval_effect3_prompt2 = """Question: {question}\n\n""" + \
"""Answer: {answer}\n\n""" + \
"""Please evaluate on whether the answer correctly answer the question. First output your reasoning and only then output your conclusion. Do not output your conclusion first. State your conclusion as Yes or No at the end of your response."""
_cot_eval_effect3_prompt3 = """Question: {question}\n\n""" + \
"""Answer: {answer}\n\n""" + \
"""Please evaluate on whether the answer correctly answer the question. First provide your own reasoning and answer to the question. Then use that to evaluate whether the answer above is correct. State your conclusion as Yes or No at the end of your response."""
_cot_eval_confidence_score_prompt = """Question: {question}\n\n""" + \
"""Answer: {answer}\n\n""" + \
"""How correct is your answer to the question? Please ONLY output your answer's correctness level on a scale of 1 to 10, no other words or explanation."""
_cot_eval_confidence_probability_prompt = """Question: {question}\n\n""" + \
"""Answer: {answer}\n\n""" + \
"""Provide the probability that your guess is correct. Give ONLY the probability between 0.0 to 1.0, no other words or explanation."""

def make_fewshot(fewshot):
    return """Does the answer correctly answer the question? First output your reasoning and only then output your conclusion. Do not output your conclusion first. State your conclusion as Yes or No at the end of your response. """ + \
f"Here are some examples:\n{fewshot}\n(End of Examples)\n\n" + \
"""Question: {question}\n""" + \
"""Answer: {answer}\nEvaluation: """ 
def make_fewshot2(fewshot):
    return """Does the answer correctly answer the question? """ + \
f"Here are some examples:\n{fewshot}\n(End of Examples)\n\n" + \
"""First output your reasoning and only then output your conclusion. \n""" + \
"""Question: {question}\n""" + \
"""Answer: {answer}\nEvaluation: """ 
def make_fewshot3(fewshot):
    return """Please evaluate on whether the answer correctly answer the question. First provide your own reasoning and answer to the question. Then use that to evaluate whether the answer above is correct. State your conclusion as Yes or No at the end of your response. You have the tendency to answer yes it is correct. But please be careful to give an accurate response. """ + \
f"Here are some examples:\n{fewshot}\n(End of Examples)\n\n" + \
"""Question: {question}\n""" + \
"""Answer: {answer}\nEvaluation: """
def make_fewshot4(fewshot):
    return f"{fewshot}\n(End of Examples)\n\n" + \
"""Question: {question}\n""" + \
"""Answer: {answer}\nEvaluation: """
def fewshot_anecdotal(fewshot):
    return f"{fewshot}\n\n" + \
"""Question: {question}\n""" + \
"""Answer: {answer}\n\nDid the answer correctly answer the question?\n"""
# print(make_fewshot4(cot_llama_long_fewshots2))

def make_template_cot_eval(prompt):
    return PromptTemplate(
                        input_variables=["question","answer"],
                        template = prompt)

CoT_Eval_Analysis = {"COT_EVAL_EFFECT1":make_template_cot_eval(_cot_eval_effect1_prompt),
                     "COT_EVAL_EFFECT2":make_template_cot_eval(_cot_eval_effect2_prompt),
                    "COT_EVAL_EFFECT2_2":make_template_cot_eval(_cot_eval_effect2_prompt2),
                     "COT_EVAL_EFFECT3":make_template_cot_eval(_cot_eval_effect3_prompt),
                     "COT_EVAL_EFFECT3_2":make_template_cot_eval(_cot_eval_effect3_prompt2),
                     "COT_EVAL_EFFECT3_3":make_template_cot_eval(_cot_eval_effect3_prompt3),
                    "COT_FEWSHOT_EVAL_EFFECT3":make_template_cot_eval(make_fewshot(cot_first3allwrong_eval_fewshots)),
                    "COT_FEWSHOT2_EVAL_EFFECT3":make_template_cot_eval(make_fewshot(cot_first3allwrong_eval2_fewshots)),
                    "COT_FEWSHOT3_EVAL_EFFECT3":make_template_cot_eval(make_fewshot(cot_first3allwrong_eval3_fewshots)),
                    "COT_FEWSHOT4_EVAL_EFFECT3":make_template_cot_eval(make_fewshot(cot_first3allwrong_eval4_fewshots)),
                    "COT_FEWSHOT5_EVAL_EFFECT3":make_template_cot_eval(make_fewshot(cot_first3allwrong_eval5_fewshots)),
                    "COT_FEWSHOT6_EVAL_EFFECT3":make_template_cot_eval(make_fewshot(cot_first3allwrong_eval6_fewshots)),
                    "COT_FEWSHOT8_EVAL_EFFECT3":make_template_cot_eval(make_fewshot2(cot_first3allwrong_eval2_fewshots)),
                    "COT_FEWSHOT9_EVAL_EFFECT3":make_template_cot_eval(make_fewshot3(cot_first3allwrong_eval2_fewshots)),
                    "LLAMA_COT_FEWSHOT_EVAL_EFFECT3":make_template_cot_eval(make_fewshot3(cot_first3allwrong_eval6_fewshots)),
                    "LLAMA2_COT_FEWSHOT_EVAL_EFFECT3":make_template_cot_eval(make_fewshot3(cot_llama_long_fewshots)),
                    "LLAMA_COT_FEWSHOT_EVAL_CLEAN":make_template_cot_eval(fewshot_anecdotal(cot_llama_long_fewshots2_no_structure)),
                    "LLAMA_COT_FEWSHOT_EVAL_ANECDOTAL":make_template_cot_eval(fewshot_anecdotal(cot_llama_long_fewshots2_no_structure)),
                    "COT_EVAL_CONFIDENCE_SCORE":make_template_cot_eval(_cot_eval_confidence_score_prompt),
                    "COT_EVAL_CONFIDENCE_PROBABILITY":make_template_cot_eval(_cot_eval_confidence_probability_prompt),

}
CoT_Eval_Analysis_SYSTEM = """Please evalaute the answer to given math questions. Your goal is to determine whether the answer correctly answer the question. Think deeply about the reasoning steps and the answer. Accuracy and correctness are more important than plausible answers."""
##############################################