from multi_skill_orchestration_ai.openapi import parse_openapi, openapi_to_agent_infos, all_operations
import msgspec, traceback

def get_agent_infos(action_dict):
    agent_info_dict = {}
    for action in action_dict.keys():
        try:
            raw_schema = action_dict[action]
            validated_spec = parse_openapi(action_dict[action])
            agent_info_dict[action] = {}
            for operation in all_operations(validated_spec):
                # agent_info_dict[action][operation.operationId] = openapi_to_agent_infos(validated_spec, operation_id=operation.operationId)
                agent_infos = openapi_to_agent_infos(validated_spec, operation_id=operation.operationId)
                for i in range(len(agent_infos)):
                    for j in range(len(agent_infos[i]['actuator_signature']['in_sig_full'])):
                        input_name = agent_infos[i]['actuator_signature']['in_sig_full'][j]['name'].replace('/','')
                        if operation.request_body:
                            for content_type in operation.request_body.content.keys():
                                if input_name in operation.request_body.content[content_type].schema.properties.keys():
                                    title = operation.request_body.content[content_type].schema.properties[input_name].description
                                    if (isinstance(title, msgspec.UnsetType) or title == "" or title == "undefined"):
                                        title = operation.request_body.content[content_type].schema.properties[input_name].title

                                    agent_infos[i]['actuator_signature']['in_sig_full'][j]['title'] = title
                                else: 
                                    for key in operation.request_body.content[content_type].schema.properties.keys():
                                        if operation.request_body.content[content_type].schema.properties[
                                                key].items:
                                            items = \
                                                operation.request_body.content[content_type].schema.properties[
                                                    key].items.properties
                                            for item in items.keys():
                                                if input_name in item:
                                                    title = items[item].description
                                                    if (isinstance(title, msgspec.UnsetType) or title == "" or title == "undefined"):
                                                        title = items[item].title

                                                    agent_infos[i]['actuator_signature']['in_sig_full'][j]['title'] = title
                        
                        
                        if 'title' not in agent_infos[i]['actuator_signature']['in_sig_full'][j] or isinstance(agent_infos[i]['actuator_signature']['in_sig_full'][j].get('title'), msgspec.UnsetType) or agent_infos[i]['actuator_signature']['in_sig_full'][j].get('title') == "undefined":
                            # if input_name == 'gid' and action == 'asana_tasks' and operation.operationId == 'deletewithwhere_Tasks':
                            #     print(input_name)
                            #     print(operation.operationId)
                            #     raw_params = raw_schema['components']['parameters']
                            #     for raw_param in raw_params.keys():
                            #         if input_name == raw_param or input_name ==  raw_schema['components']['parameters'][raw_param]['name']:
                            #             print('found', raw_param)
                            for param in operation.parameters:
                                # print(param)
                                # print(title)
                                if input_name == param.name:
                                    title = param.schema.description
                                    if (isinstance(title, msgspec.UnsetType) or title == "" or title == "undefined"):
                                        title = param.schema.title
                                    if not (isinstance(title, msgspec.UnsetType) or title == "" or title == "undefined"):
                                        agent_infos[i]['actuator_signature']['in_sig_full'][j]['title'] = title
                                    else:
                                        # if input_name == 'accountName' and action == 'asana_tasks':
                                        #     print(input_name)
                                        #     print(operation.operationId)
                                        if "components" in raw_schema.keys() and "parameters" in raw_schema["components"].keys():
                                            raw_params = raw_schema['components']['parameters']
                                            for raw_param in raw_params.keys():
                                                if input_name == raw_param or input_name ==  raw_schema['components']['parameters'][raw_param].get('name'):
                                                    if "description" in raw_schema['components']['parameters'][raw_param]:
                                                        title = raw_schema['components']['parameters'][raw_param]["description"]
                                                        agent_infos[i]['actuator_signature']['in_sig_full'][j]['title'] = title
                                                    if (isinstance(title, msgspec.UnsetType) or title == "" or title == "undefined") and "title" in raw_schema['components']['parameters'][raw_param]:
                                                        title = raw_schema['components']['parameters'][raw_param]["title"]
                                                        agent_infos[i]['actuator_signature']['in_sig_full'][j]['title'] = title
                                                    if (isinstance(title, msgspec.UnsetType) or title == "" or title == "undefined") and "x-ibm-title" in raw_schema['components']['parameters'][raw_param]:
                                                        title = raw_schema['components']['parameters'][raw_param]["x-ibm-title"]
                                                        agent_infos[i]['actuator_signature']['in_sig_full'][j]['title'] = title
                                                    break
                                        else:
                                            agent_infos[i]['actuator_signature']['in_sig_full'][j]['title'] = title
                            # print(title)
                    # print(agent_infos[i]['actuator_signature']['out_sig_full'])
                    for j in range(len(agent_infos[i]['actuator_signature']['out_sig_full'])):
                        output_name = agent_infos[i]['actuator_signature']['out_sig_full'][j]['name'].split('/')[-1].replace('/', '')
                        # print(output_name)
                        for response_number in operation.responses.keys():
                            # print(operation.responses[response_number].content['application/json'].schema.properties.keys())
                            if 'application/json' in operation.responses[response_number].content.keys() and output_name in operation.responses[response_number].content['application/json'].schema.properties.keys():
                                title = operation.responses[response_number].content['application/json'].schema.properties[output_name].description
                                if (isinstance(title, msgspec.UnsetType) or title == ""):
                                    title = operation.responses[response_number].content['application/json'].schema.properties[output_name].title
                                agent_infos[i]['actuator_signature']['out_sig_full'][j]['title'] = title
                            elif 'application/json' in operation.responses[response_number].content.keys():
                                for key in operation.responses[response_number].content['application/json'].schema.properties.keys():
                                    if operation.responses[response_number].content['application/json'].schema.properties[
                                        key].items:
                                        items = \
                                        operation.responses[response_number].content['application/json'].schema.properties[
                                            key].items.properties
                                        for item in items.keys():
                                            if output_name in item:
                                                title = items[item].description
                                                if (isinstance(title, msgspec.UnsetType) or title == ""):
                                                    title = items[item].title
                                                agent_infos[i]['actuator_signature']['out_sig_full'][j]['title'] = title
                            
                    if operation.callbacks:
                        for j in range(len(agent_infos[i]['actuator_signature']['out_sig_full'])):
                            output_name = agent_infos[i]['actuator_signature']['out_sig_full'][j]['name'].split('/')[-1].replace('/', '')
                            # print(output_name)
                            if 'postResponse' in operation.callbacks.keys() and 'output' in operation.callbacks['postResponse']['{$request.header.callbackUrl}'].post.request_body.content[
                                'application/json'].schema.properties.keys() and output_name in operation.callbacks['postResponse']['{$request.header.callbackUrl}'].post.request_body.content[
                                'application/json'].schema.properties['output'].properties.keys():
                                title = operation.callbacks['postResponse']['{$request.header.callbackUrl}'].post.request_body.content[
                                'application/json'].schema.properties['output'].properties[output_name].description
                                if (isinstance(title, msgspec.UnsetType) or title == ""):
                                    title = operation.callbacks['postResponse']['{$request.header.callbackUrl}'].post.request_body.content[
                                'application/json'].schema.properties['output'].properties[output_name].title
                                agent_infos[i]['actuator_signature']['out_sig_full'][j]['title'] = title
                

                    for j in range(len(agent_infos[i]['actuator_signature']['in_sig_full'])):
                        if 'title' not in agent_infos[i]['actuator_signature']['in_sig_full'][j]:
                            agent_infos[i]['actuator_signature']['in_sig_full'][j]['title'] = None
                        if isinstance(agent_infos[i]['actuator_signature']['in_sig_full'][j]['title'], msgspec.UnsetType):
                            agent_infos[i]['actuator_signature']['in_sig_full'][j]['title'] = None
                    for j in range(len(agent_infos[i]['actuator_signature']['out_sig_full'])):
                        if 'title' not in agent_infos[i]['actuator_signature']['out_sig_full'][j]:
                            agent_infos[i]['actuator_signature']['out_sig_full'][j]['title'] = None
                        if isinstance(agent_infos[i]['actuator_signature']['out_sig_full'][j]['title'], msgspec.UnsetType):
                            agent_infos[i]['actuator_signature']['out_sig_full'][j]['title'] = None
                            
                agent_info_dict[action][operation.operationId] = agent_infos    
        
        except Exception as e:
            traceback.print_exc()
            print(action, ":", str(e))
            continue

    
    
    return agent_info_dict