#!/bin/bash -l

set -e
set -u

MODEL="./models/llama-2-7b-80k"

SKIP_LAYERS=("0" "0,1" "0,1,2" "0,1,2,3" "0,1,2,3,4")
KEEP_RATIOS=("1" "0.9" "0.8" "0.7" "0.6" "0.5" "0.4" "0.3" "0.2" "0.1")

for skip_layer in "${SKIP_LAYERS[@]}"; do
  for keep_ratio in "${KEEP_RATIOS[@]}"; do
    python eval_passkey.py \
      --base_model ${MODEL} \
      --keep_ratio ${keep_ratio} \
      --skip_layer ${skip_layer}
  done
done

MODEL="./models/llama-2-7b-longlora-32k-ft"

for skip_layer in "${SKIP_LAYERS[@]}"; do
  for keep_ratio in "${KEEP_RATIOS[@]}"; do
    python eval_passkey.py \
      --base_model ${MODEL} \
      --keep_ratio ${keep_ratio} \
      --skip_layer ${skip_layer}
  done
done
