# Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
# Copyright Tor Vergata, University of Rome. All Rights Reserved.
# SPDX-License-Identifier: Apache-2.0
#
# Experiment runner script

BERT_BASE_DIR=uncased_L-2_H-128_A-2

if [ ! -d ${BERT_BASE_DIR} ]; then
	wget https://storage.googleapis.com/bert_models/2020_02_20/uncased_L-2_H-128_A-2.zip
	unzip uncased_L-2_H-128_A-2.zip -d uncased_L-2_H-128_A-2
fi


SEQ_LEN="128"
BS="32"
LR="2e-5"
EPOCHS="60"
cur_dir="data-augmentation-for-trec/aug_data"
LABEL_RATE="0.02"

python -u data-augmentation-for-trec/ganbert/bert.py \
        --task_name=QC-fine \
        --label_rate=${LABEL_RATE} \
        --do_train=true \
        --do_eval=true \
        --do_predict=false \
        --data_dir=${cur_dir} \
        --vocab_file=$BERT_BASE_DIR/vocab.txt \
        --bert_config_file=$BERT_BASE_DIR/bert_config.json \
        --init_checkpoint=$BERT_BASE_DIR/bert_model.ckpt \
        --max_seq_length=${SEQ_LEN} \
        --train_batch_size=${BS} \
        --learning_rate=${LR} \
        --num_train_epochs=${EPOCHS} \
        --warmup_proportion=0.1 \
        --do_lower_case=false \
        --output_dir=bert_output_model
