# Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.  
# SPDX-License-Identifier: CC-BY-NC-4.0

import argparse
import json

from tqdm import tqdm


def main():
    parser = argparse.ArgumentParser(description="Removes context from a blink dataset")
    parser.add_argument("--input", help="Input csv files", required=True)
    parser.add_argument("--output", help="Output test set", required=True)
    args = parser.parse_args()

    with open(args.input, 'r') as reader, open(args.output, 'w') as writer:
        for line in tqdm(reader, desc="Converting dataset"):
            sample = json.loads(line)
            sample["context_left"] = ""
            sample["context_right"] = ""
            sample["label"] = ""

            writer.write(json.dumps(sample))
            writer.write('\n')


if __name__ == '__main__':
    main()
