from allennlp.predictors.predictor import Predictor
import allennlp_models.coref


class CoreferenceResolutioner:
    def __init__(self):
        self.predictor = Predictor.from_path("https://storage.googleapis.com/allennlp-public-models/coref-spanbert-large-2020.02.27.tar.gz")

    def __call__(self, text):
        result = self.predictor.predict(document=text)
        words = result['document']
        cluster_id = result['clusters']
        cluster_word = [[' '.join(words[j[0]: j[1]+1]) for j in i ] for i in cluster_id]
        return {"words": words, 'cluster_id': cluster_id, 'cluster_word': cluster_word}
    

if __name__ == "__main__":
    resolutioner = CoreferenceResolutioner()
    text = 'It reminds him of the old days, when the Is was something to make war on and carve pieces away from'
    result = resolutioner(text)
    print(result)