import argparse
import sys, getopt

import tensorflow as tf

usage_str = 'python tensorflow_rename_variables.py --checkpoint_dir=path/to/dir/ ' \
            '--replace_from=substr --replace_to=substr --add_prefix=abc --dry_run'


def rename(checkpoint_dir, output_file, replace_from, replace_to, keep_only_prefix="", dry_run=False):
    checkpoint = tf.train.get_checkpoint_state(checkpoint_dir)
    with tf.Session() as sess:
        i = 0
        for var_name, _ in tf.contrib.framework.list_variables(checkpoint_dir):
            # Load the variable
            var = tf.contrib.framework.load_variable(checkpoint_dir, var_name)

            # Set the new name
            new_name = var_name
            if not new_name.startswith(keep_only_prefix):
                new_name = f"orqa{i}"
                i += 1
            if None not in [replace_from, replace_to]:
                new_name = new_name.replace(replace_from, replace_to)

            if dry_run:
                print('%s would be renamed to %s.' % (var_name, new_name))
            else:
                print('Renaming %s to %s.' % (var_name, new_name))
                # Rename the variable
                var = tf.Variable(var, name=new_name)

        if not dry_run:
            # Save the variables
            saver = tf.train.Saver()
            sess.run(tf.global_variables_initializer())
            saver.save(sess, output_file)


if __name__ == '__main__':
    parser = argparse.ArgumentParser()

    parser.add_argument("--checkpoint_dir", "-c", required=True, type=str)
    parser.add_argument("--output_file", "-o", required=True, type=str)
    parser.add_argument("--replace_from", "-f", required=True, type=str)
    parser.add_argument("--replace_to", "-t", required=True, type=str)
    parser.add_argument("--keep_only_prefix", "-k", required=True, type=str)

    args = parser.parse_args()

    rename(args.checkpoint_dir, args.output_file, args.replace_from, args.replace_to, args.keep_only_prefix)
