#!/usr/bin/env bash
set -e 
set -x 


GPU='0'
SEED=('42' '9' '12' '21')

for zone in "${SEED[@]}"
do
CKPT_NAME='baseline_'${zone}

python train_bart_gen.py \
    --ckpt_name=${CKPT_NAME} \
    --train_batch_size=4 \
    --gpus ${GPU} \
    --learning_rate 3e-5 \
    --data_file=preprocessed/preprocessed_${CKPT_NAME} \
    --seed ${zone}
done   
