
from __future__ import absolute_import
from __future__ import division
from __future__ import print_function
import sys
import os

def merge_rank(finename):
    fout = open('outputs/convert_result.tsv', 'w')
    for line in open(finename):
        items = line.strip().split('\t')
        qry, neg, idx, score = items[0], eval(items[1]), int(items[2]), eval(items[3])
        tups = []
        for a, b in zip(neg, score):
            tups.append((a, b))
        tups.sort(key=lambda a: a[1], reverse=True)
        sort_ = [_a[0] for _a in tups]
        for i, _neg in enumerate(sort_):
            print(qry, _neg, i + 1, sep='\t', file=fout)
    fout.close()

def check_dev_passage():
    input_path = sys.argv[1]
    path_to_reference = sys.argv[2]
    files = os.listdir(input_path)
    for file_ in files:
        if file_.endswith('tsv'):
            print(file_)
            merge_rank(os.path.join(input_path, file_))
            os.system("python3 tools/ms_marco_eval_passage.py outputs/convert_result.tsv %s" % path_to_reference)

def check_dev_document():
    input_path = sys.argv[1]
    path_to_reference = sys.argv[2]
    files = os.listdir(input_path)
    for file_ in files:
        if file_.endswith('tsv'):
            print(file_)
            merge_rank(os.path.join(input_path, file_))
            os.system("python3 tools/ms_marco_eval_document.py outputs/convert_result.tsv %s" % path_to_reference)

if __name__ == "__main__":
    check_dev_document()
