### Cross-domain Named Entity Recognition via Graph Matching

#### Dependency

- python == 3.6
- torch == 1.9.0
- torchvision == 0.10.0
- torchtext == 0.6.0
- transformers == 4.12.2
- dgl == 0.7.1



#### Datasets

- CoNLL 2003: https://arxiv.org/pdf/cs/0306050.pdf
- CrossNER: https://github.com/zliucr/CrossNER
- MIT movie and MIT restaurant: https://groups.csail.mit.edu/sls/downloads/
- ATIS: https://github.com/yvchen/JointSLU



#### Configurations

-  `--exp_name`: the experiment name
-  `--logger_filename`: the log file name
-  `--dump_path`: the experiment save path 
-  `--exp_id`: the experiment id 
-  `--model_name`: the model name
-  `--ckpt`: the pre-train Language Model
-  `--src_dm`: the source domain 
-  `--tgt_dm`: the target domain 
-  `--debug`: if skipping validation 
-  `--epoch_target`: the number of epoch in target domain 
-  `--batch_size_target`: the batch size in target domain  
-  `--lr_target`: the initial learning rate 
-  `--schedule_target`: multi-step scheduler 
-  `--lambda_1`: the weight of the auxiliary task 
-  `--lambda_2`: the weight of graph matching
-  `--temperature`: temperature of score
