import os
import re
import numpy as np

from configs.supported import algorithms
BASE_DIR = '/home/iliasc/temporal-wilds/logs/eurlex/BATCH_64_LWAN_MORE_EPOCHS'

SPLITS = ['train', 'dev', 'test']
score_dicts = {}
for algo in algorithms:
    score_dict = {'train': [],
                  'dev': [],
                  'test': []}
    for idx in range(1, 4):
        algo_dir = os.path.join(BASE_DIR, f'{algo}_{idx}')
        if os.path.exists(os.path.join(BASE_DIR, f'{algo}_{idx}')):
            with open(os.path.join(algo_dir, 'log.txt')) as file:
                text = file.read()
                try:
                    evaluation_report = text.split('\nEvaluation\n')[1]
                    eval_splits = evaluation_report.split('\nEval split ')[1:]
                    for eval_split, split in zip(eval_splits, SPLITS):
                        avg_score = float(re.search(r'Average F1-micro: ([0-9\.]{5})', eval_split).group(1))
                        score_dict[split].append(avg_score)
                except:
                    print(f'{algo}_{idx} is missing!')
        else:
            break

    print(f'{algo:>20}:\t', end='')
    for split in SPLITS:
        print(f'AVG: {np.mean(score_dict[split]):.3f} +/- {np.std(score_dict[split]):.3f}\t', end='')
    print()
    print('-'*100)
