# -*- coding: utf-8 -*-

import csv
from typing import List


def read_mod_from_file(filename: str):
    mods = []
    with open(filename) as csvfile:
        spamreader = csv.reader(csvfile, delimiter=',', quotechar="'", skipinitialspace=True)
        for i, row in enumerate(spamreader):
            if i == 0:
                continue
            mods.append(row)
    
    return mods


def concatenate_mod_to_all(lines: List[str], prefix: str, suffix: str) -> List[str]:
    mod_lines = []
    for line in lines:
        mod_lines.append(prefix + line + suffix)
    
    return mod_lines

