def eval_sentence(y_pred, words, evltag):
    seg_pred = []
    word_pred = ''
    for i in range(len(y_pred)):
        word_pred += words[i]
        if y_pred[i] in evltag:
            seg_pred.append(word_pred)
            word_pred = ''
    seg_pred_str = ' '.join(seg_pred)
    return seg_pred_str


def cws_evaluate_word_PRF(y_pred, y, evltag):
    cor_num = 0
    yp_wordnum = sum([y_pred.count(c) for c in evltag])
    yt_wordnum = sum([y.count(c) for c in evltag])
    start = 0
    for i in range(len(y)):
        if y[i] in evltag:
            flag = True
            for j in range(start, i+1):
                if y[j] != y_pred[j]:
                    flag = False
            if flag:
                cor_num += 1
            start = i+1

    P = cor_num / float(yp_wordnum) if yp_wordnum > 0 else -1
    R = cor_num / float(yt_wordnum) if yt_wordnum > 0 else -1
    F = 2 * P * R / (P + R)
    return P, R, F


def cws_evaluate_OOV(y_pred_list, y_list, sentence_list, word2id, evltag):
    cor_num = 0
    yt_wordnum = 0
    for y_pred, y, sentence in zip(y_pred_list, y_list, sentence_list):
        start = 0
        for i in range(len(y)):
            if y[i] in evltag:
                word = ''.join(sentence[start:i+1])
                if word in word2id:
                    start = i + 1
                    continue
                flag = True
                yt_wordnum += 1
                for j in range(start, i+1):
                    if y[j] != y_pred[j]:
                        flag = False
                if flag:
                    cor_num += 1
                start = i + 1

    OOV = cor_num / float(yt_wordnum) if yt_wordnum > 0 else -1
    return OOV